/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import java.util.regex.Pattern;

public class CpuFeatures {
    private static final String UNAME_OPTION_MACHINE_TYPE = "-m";
    private static final String UNAME_OPTION_KERNEL_RELEASE = "-r";

    private static String uname(ITestDevice device, String option) throws DeviceNotAvailableException {
        CollectingOutputReceiver Out = new CollectingOutputReceiver();
        device.executeShellCommand("uname " + option, (IShellOutputReceiver)Out);
        return Out.getOutput().trim();
    }

    public static boolean isArm64(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.uname(device, UNAME_OPTION_MACHINE_TYPE).contains("aarch64");
    }

    public static boolean isArm32(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.uname(device, UNAME_OPTION_MACHINE_TYPE).contains("armv7");
    }

    public static boolean isX86(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.uname(device, UNAME_OPTION_MACHINE_TYPE).contains("86");
    }

    public static boolean isX86_64(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.uname(device, UNAME_OPTION_MACHINE_TYPE).contains("x86_64");
    }

    public static boolean isX86_32(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.isX86(device) && !CpuFeatures.isX86_64(device);
    }

    public static boolean isNativeAbi(ITestDevice device, String abi) throws DeviceNotAvailableException {
        if (CpuFeatures.isArm32(device) && abi.equals("armeabi-v7a")) {
            return true;
        }
        if (CpuFeatures.isArm64(device) && abi.contains("arm")) {
            return true;
        }
        if (CpuFeatures.isX86_32(device) && abi.equals("x86")) {
            return true;
        }
        return CpuFeatures.isX86_64(device) && abi.contains("x86");
    }

    public static boolean kernelVersionLessThan(ITestDevice device, int major, int minor) throws DeviceNotAvailableException {
        String[] kernelVersion = CpuFeatures.uname(device, UNAME_OPTION_KERNEL_RELEASE).split(Pattern.quote("."));
        int deviceMajor = Integer.parseInt(kernelVersion[0]);
        int deviceMinor = Integer.parseInt(kernelVersion[1]);
        return major > deviceMajor || major == deviceMajor && minor > deviceMinor;
    }
}

