/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.TestResult;
import com.android.compatibility.common.util.TestStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CaseResult
implements ICaseResult {
    private String mName;
    private Map<String, ITestResult> mResults = new HashMap<String, ITestResult>();

    public CaseResult(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public ITestResult getOrCreateResult(String testName) {
        ITestResult result = this.mResults.get(testName);
        if (result == null) {
            result = new TestResult(this, testName);
            this.mResults.put(testName, result);
        }
        return result;
    }

    @Override
    public ITestResult getResult(String testName) {
        return this.mResults.get(testName);
    }

    @Override
    public List<ITestResult> getResults(TestStatus status) {
        ArrayList<ITestResult> results = new ArrayList<ITestResult>();
        for (ITestResult result : this.mResults.values()) {
            if (result.getResultStatus() != status) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public List<ITestResult> getResults() {
        ArrayList<ITestResult> results = new ArrayList<ITestResult>(this.mResults.values());
        Collections.sort(results);
        return results;
    }

    @Override
    public int countResults(TestStatus status) {
        int total = 0;
        for (ITestResult result : this.mResults.values()) {
            if (result.getResultStatus() != status) continue;
            ++total;
        }
        return total;
    }

    @Override
    public int compareTo(ICaseResult another) {
        return this.getName().compareTo(another.getName());
    }

    @Override
    public void mergeFrom(ICaseResult otherCaseResult) {
        if (!otherCaseResult.getName().equals(this.getName())) {
            throw new IllegalArgumentException(String.format("Cannot merge case result with mismatched name. Expected %s, Found %s", otherCaseResult.getName(), this.getName()));
        }
        for (ITestResult otherTestResult : otherCaseResult.getResults()) {
            this.mResults.put(otherTestResult.getName(), otherTestResult);
        }
    }
}

