/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.version;

import com.google.common.base.Splitter;
import com.google.devtools.mobileharness.api.model.error.BasicErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import java.util.List;

public final class Version
implements Comparable<Version> {
    public static final Version CLIENT_VERSION = new Version(4, 32, 0);
    public static final Version MIN_CLIENT_VERSION = new Version(4, 29, 0);
    public static final Version LAB_VERSION = new Version(4, 347, 0);
    public static final Version MIN_LAB_VERSION = new Version(4, 126, 0);
    public static final Version MASTER_V5_VERSION = new Version(5, 29, 0);
    public static final Version MIN_MASTER_V5_VERSION = new Version(5, 0, 1);
    private final int major;
    private final int minor;
    private final int revision;

    private Version() {
        this(-1, -1, -1);
    }

    public Version(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public Version(String version) throws MobileHarnessException {
        String errMsg = "Version string format error, expected format: x.y.z (x, y, z are non-negative numbers), got: " + version;
        List<String> strs = Splitter.on(".").splitToList(version);
        if (strs.size() != 3) {
            throw new MobileHarnessException(BasicErrorId.VERSION_SEQUENCE_LENGTH_ERROR, errMsg);
        }
        int[] nums = new int[strs.size()];
        for (int i = 0; i < strs.size(); ++i) {
            try {
                nums[i] = Integer.parseInt(strs.get(i));
            }
            catch (NumberFormatException e) {
                throw new MobileHarnessException(BasicErrorId.VERSION_NUM_FORMAT_ERROR, errMsg, e);
            }
            if (nums[i] >= 0) continue;
            throw new MobileHarnessException(BasicErrorId.VERSION_NUM_RANGE_ERROR, errMsg);
        }
        this.major = nums[0];
        this.minor = nums[1];
        this.revision = nums[2];
    }

    @Override
    public int compareTo(Version other) {
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        return this.revision - other.revision;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof Version) {
            return this.compareTo((Version)other) == 0;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }
}

