/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.path;

import com.google.common.base.Strings;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathUtil {
    private static final Pattern SLASH_PREFIX_PATTERN = Pattern.compile("^/+");
    private static final Pattern TWO_OR_MORE_SLASH_PATTERN = Pattern.compile("/{2,}");
    private static final Pattern NON_SLASH_SUFFIX_PATTERN = Pattern.compile("(.*[^/])/+$");

    public static boolean isAbsolute(String path) {
        return !path.isEmpty() && path.charAt(0) == '/';
    }

    public static String basename(String path) {
        if ((path = PathUtil.removeLeadingSlashes(PathUtil.removeExtraneousSlashes(path))).length() == 0) {
            return path;
        }
        int pos = path.lastIndexOf("/");
        if (pos == -1) {
            return path;
        }
        return path.substring(pos + 1);
    }

    public static String join(String ... components) {
        int len = components.length - 1;
        if (len == -1) {
            return "";
        }
        for (String component : components) {
            len += component.length();
        }
        char[] path = new char[len];
        int i = 0;
        for (String component : components) {
            if (component.isEmpty()) continue;
            if (i > 0 && path[i - 1] != '/') {
                path[i++] = 47;
            }
            int end = component.length();
            for (int j = 0; j < end; ++j) {
                char c = component.charAt(j);
                if (c == '/' && i > 0 && path[i - 1] == '/') continue;
                path[i++] = c;
            }
        }
        return new String(path, 0, i);
    }

    public static String dirname(String path) {
        path = PathUtil.removeExtraneousSlashes(path);
        int lastSlash = path.lastIndexOf("/");
        if ("/".equals(path) || lastSlash == 0) {
            return "/";
        }
        if (lastSlash == -1) {
            return ".";
        }
        return path.substring(0, lastSlash);
    }

    public static String makeRelative(String dir, String fullPath) {
        dir = PathUtil.removeExtraneousSlashes(dir);
        String relativePath = (fullPath = PathUtil.removeExtraneousSlashes(fullPath)).startsWith(dir) ? fullPath.substring(dir.length()) : fullPath;
        String clean = relativePath.replace("/../", "/").replace("/..", "/").replace("../", "/");
        relativePath = PathUtil.join(clean.split("/"));
        relativePath = PathUtil.removeLeadingSlashes(relativePath);
        return relativePath;
    }

    public static String removeExtraneousSlashes(String s2) {
        Matcher m4 = NON_SLASH_SUFFIX_PATTERN.matcher(s2);
        if (m4.matches()) {
            s2 = s2.substring(0, m4.end(1));
        }
        return TWO_OR_MORE_SLASH_PATTERN.matcher(s2).replaceAll("/");
    }

    public static String removeLeadingSlashes(String path) {
        return SLASH_PREFIX_PATTERN.matcher(path).replaceFirst("");
    }

    public static String completeHomeDirectory(String path) {
        if (path.startsWith("~" + File.separator)) {
            return Strings.nullToEmpty(System.getProperty("user.home")) + path.substring(1);
        }
        if (path.equals("~")) {
            return Strings.nullToEmpty(System.getProperty("user.home"));
        }
        return path;
    }

    private PathUtil() {
    }
}

