/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.flags;

import com.beust.jcommander.IStringConverter;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.mobileharness.shared.util.flags.Flag;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationFlag
extends Flag<Duration> {
    private static final ImmutableMap<String, Duration> ABBREVIATION_TO_DURATION = new ImmutableMap.Builder<String, Duration>().put("d", Duration.ofDays(1L)).put("h", Duration.ofHours(1L)).put("m", Duration.ofMinutes(1L)).put("s", Duration.ofSeconds(1L)).put("ms", Duration.ofMillis(1L)).put("us", Duration.of(1L, ChronoUnit.MICROS)).put("ns", Duration.ofNanos(1L)).buildOrThrow();
    private static final String UNIT_PATTERN_STRING = "(?x) (?<whole>[0-9]+)? (?<frac>\\.[0-9]*)? (?<unit>d|h|ms?|s|us|ns)";
    private static final Pattern UNIT_PATTERN = Pattern.compile("(?x) (?<whole>[0-9]+)? (?<frac>\\.[0-9]*)? (?<unit>d|h|ms?|s|us|ns)");
    private static final CharMatcher ASCII_DIGIT = CharMatcher.inRange('0', '9');

    static DurationFlag value(Duration defaultValue) {
        return new DurationFlag(defaultValue);
    }

    private DurationFlag(Duration value) {
        super(value);
    }

    private static Duration parseDuration(String value) {
        Preconditions.checkArgument(value != null, "input value cannot be null");
        Preconditions.checkArgument(!value.isEmpty(), "input value cannot be empty");
        Preconditions.checkArgument(!value.equals("-"), "input value cannot be '-'");
        Preconditions.checkArgument(!value.equals("+"), "input value cannot be '+'");
        value = CharMatcher.whitespace().trimFrom(value);
        if ("0".equals(value)) {
            return Duration.ZERO;
        }
        Duration duration = Duration.ZERO;
        boolean negative = value.startsWith("-");
        boolean explicitlyPositive = value.startsWith("+");
        int index = negative || explicitlyPositive ? 1 : 0;
        Matcher matcher = UNIT_PATTERN.matcher(value);
        while (matcher.find(index) && matcher.start() == index) {
            Preconditions.checkArgument(ASCII_DIGIT.matchesAnyOf(matcher.group(0)));
            try {
                String unit = matcher.group("unit");
                long whole = Long.parseLong(MoreObjects.firstNonNull(matcher.group("whole"), "0"));
                Duration singleUnit = ABBREVIATION_TO_DURATION.get(unit);
                Preconditions.checkArgument(singleUnit != null, "invalid unit (%s)", (Object)unit);
                duration = duration.plus(singleUnit.multipliedBy(whole));
                long nanosPerUnit = singleUnit.toNanos();
                double frac = Double.parseDouble("0" + MoreObjects.firstNonNull(matcher.group("frac"), ""));
                duration = duration.plus(Duration.ofNanos((long)((double)nanosPerUnit * frac)));
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException(e);
            }
            index = matcher.end();
        }
        if (index < value.length()) {
            throw new IllegalArgumentException("Could not parse entire duration: " + value);
        }
        if (negative) {
            duration = duration.negated();
        }
        return duration;
    }

    public static class DurationConverter
    implements IStringConverter<DurationFlag> {
        @Override
        public DurationFlag convert(String value) {
            return DurationFlag.value(DurationFlag.parseDuration(value));
        }
    }
}

