/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.io;

import com.google.devtools.mobileharness.shared.util.command.io.LineReader;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;

public class LineCollector
implements LineReader.LineHandler {
    private final CountDownLatch sourceCloseLatch;
    private final boolean needAllLines;
    private final Object handleLineLock = new Object();
    @GuardedBy(value="handleLineLock")
    private final StringBuilder allLinesBuilder = new StringBuilder();
    @GuardedBy(value="handleLineLock")
    private String allLines;
    @GuardedBy(value="handleLineLock")
    private Predicate<String> lineConsumer;
    @GuardedBy(value="handleLineLock")
    private boolean stopConsumingLines;

    public LineCollector(int numSource, boolean needAllLines) {
        this.sourceCloseLatch = new CountDownLatch(numSource);
        this.needAllLines = needAllLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleLine(String line, String end) {
        Object object = this.handleLineLock;
        synchronized (object) {
            if (this.needAllLines) {
                this.allLinesBuilder.append(line);
                this.allLinesBuilder.append(end);
            }
            if (!this.stopConsumingLines && this.lineConsumer != null) {
                this.stopConsumingLines = this.lineConsumer.test(line);
            }
            return !this.needAllLines && this.stopConsumingLines;
        }
    }

    @Override
    public void onSourceClosed() {
        this.sourceCloseLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineConsumer(Predicate<String> lineConsumer) {
        Object object = this.handleLineLock;
        synchronized (object) {
            this.lineConsumer = lineConsumer;
        }
    }

    public String waitForAllLines() throws InterruptedException {
        this.sourceCloseLatch.await();
        return this.getAllLines();
    }

    public String waitForAllLines(Duration timeout) throws InterruptedException {
        this.sourceCloseLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this.getAllLines();
    }

    public boolean notAllSourceClosed() {
        return this.sourceCloseLatch.getCount() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConsumingLines() {
        Object object = this.handleLineLock;
        synchronized (object) {
            this.stopConsumingLines = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAllLines() {
        Object object = this.handleLineLock;
        synchronized (object) {
            if (this.allLines == null) {
                this.allLines = this.allLinesBuilder.toString();
            }
            return this.allLines;
        }
    }
}

