/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.history;

import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.shared.util.command.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.history.CommandHistory;
import com.google.devtools.mobileharness.shared.util.command.history.CommandRecord;
import com.google.devtools.mobileharness.shared.util.command.history.CommandRecorderListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CommandRecorder {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final CommandRecorder INSTANCE = new CommandRecorder(CommandHistory.getInstance());
    private final CommandHistory commandHistory;
    private final CopyOnWriteArrayList<CommandRecorderListener> listeners = new CopyOnWriteArrayList();

    public static CommandRecorder getInstance() {
        return INSTANCE;
    }

    private CommandRecorder(CommandHistory commandHistory) {
        this.commandHistory = commandHistory;
    }

    public synchronized void addListener(CommandRecorderListener listener) {
        this.listeners.add(listener);
    }

    public CommandRecord addCommand(List<String> command) {
        return this.commandHistory.addCommand(command);
    }

    public void addCommandResult(CommandRecord commandRecord, CommandResult result) {
        this.commandHistory.addCommandResult(commandRecord, result);
        for (CommandRecorderListener listener : this.listeners) {
            try {
                listener.onAddCommandResult(commandRecord, result);
            }
            catch (RuntimeException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(e)).log("Failed to execute command recorder listener %s", listener.getClass().getName());
            }
        }
    }
}

