/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.backend;

import com.google.auto.value.AutoValue;
import com.google.common.base.VerifyException;
import com.google.common.io.ByteSink;
import com.google.devtools.mobileharness.shared.util.command.backend.AutoValue_LineConsumingByteSink;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import javax.annotation.Nullable;

@AutoValue
abstract class LineConsumingByteSink
extends ByteSink {
    LineConsumingByteSink() {
    }

    static ByteSink create(Consumer<String> consumer, Charset charset) {
        return new AutoValue_LineConsumingByteSink(consumer, charset);
    }

    abstract Consumer<String> consumer();

    abstract Charset charset();

    @Override
    public final OutputStream openStream() {
        return new Stream();
    }

    private final class Stream
    extends OutputStream {
        @Nullable
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private boolean wasReturn;

        private Stream() {
        }

        @Override
        public void write(int b) throws IOException {
            boolean isReturn;
            if (this.buffer == null) {
                throw new IOException("stream is closed");
            }
            boolean isNewline = b == 10;
            boolean bl = isReturn = b == 13;
            if (!isNewline || !this.wasReturn) {
                if (isNewline || isReturn) {
                    this.consumeLine();
                    this.buffer.reset();
                } else {
                    this.buffer.write(b);
                }
            }
            this.wasReturn = isReturn;
        }

        @Override
        public void close() {
            if (this.buffer != null && this.buffer.size() > 0) {
                this.consumeLine();
            }
            this.buffer = null;
        }

        private void consumeLine() {
            String line;
            try {
                line = this.buffer.toString(LineConsumingByteSink.this.charset().name());
            }
            catch (UnsupportedEncodingException e) {
                throw new VerifyException(e);
            }
            LineConsumingByteSink.this.consumer().accept(line);
        }
    }
}

