/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.shared.util.command.AutoValue_Timeout;
import com.google.devtools.mobileharness.shared.util.time.CountDownTimer;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

@AutoValue
public abstract class Timeout {
    public static Timeout fixed(Duration timeout) {
        return Timeout.builder().period(timeout).build();
    }

    public static Timeout deadline(CountDownTimer deadline) {
        return Timeout.builder().deadline(deadline).build();
    }

    public static Timeout deadline(Instant deadline) {
        return Timeout.deadline(new FixedDeadline(deadline));
    }

    public static Timeout of(Duration fixedTimeout, CountDownTimer deadline) {
        return Timeout.builder().period(fixedTimeout).deadline(deadline).build();
    }

    public static Timeout of(Duration fixedTimeout, Instant deadline) {
        return Timeout.of(fixedTimeout, new FixedDeadline(deadline));
    }

    public Timeout withFixed(Duration timeout) {
        return this.toBuilder().period(timeout).build();
    }

    public Timeout withDeadline(CountDownTimer deadline) {
        return this.toBuilder().deadline(deadline).build();
    }

    public Timeout withDeadline(Instant deadline) {
        return this.withDeadline(new FixedDeadline(deadline));
    }

    public Duration getRemainingTime() throws MobileHarnessException {
        Optional<Duration> period;
        Duration remainingTime = null;
        Optional<CountDownTimer> deadline = this.getDeadline();
        if (deadline.isPresent()) {
            remainingTime = deadline.get().remainingTimeJava();
        }
        if ((period = this.getPeriod()).isPresent() && (remainingTime == null || period.get().compareTo(remainingTime) < 0)) {
            remainingTime = period.get();
        }
        return remainingTime;
    }

    public abstract Optional<Duration> getPeriod();

    public abstract Optional<CountDownTimer> getDeadline();

    abstract Builder toBuilder();

    private static Builder builder() {
        return new AutoValue_Timeout.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder period(Duration var1);

        abstract Builder deadline(CountDownTimer var1);

        abstract Timeout autoBuild();

        private Timeout build() {
            Timeout timeout = this.autoBuild();
            Preconditions.checkState(timeout.getPeriod().isPresent() || timeout.getDeadline().isPresent(), "Timeout should have period or deadline");
            return timeout;
        }
    }

    @VisibleForTesting
    static class FixedDeadline
    implements CountDownTimer {
        private final Instant deadline;

        @VisibleForTesting
        FixedDeadline(Instant deadline) {
            this.deadline = deadline;
        }

        @Override
        public Instant expireTime() {
            return this.deadline;
        }

        @Override
        public boolean isExpired() {
            return this.deadline.isBefore(Instant.now());
        }

        @Override
        public Duration remainingTimeJava() {
            return Duration.between(Instant.now(), this.deadline);
        }
    }
}

