/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.devtools.mobileharness.shared.util.command.$AutoValue_Command;
import com.google.devtools.mobileharness.shared.util.command.CommandResult;
import com.google.devtools.mobileharness.shared.util.command.LineCallback;
import com.google.devtools.mobileharness.shared.util.command.Timeout;
import com.google.devtools.mobileharness.shared.util.time.CountDownTimer;
import com.google.errorprone.annotations.CheckReturnValue;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

@AutoValue
public abstract class Command {
    public static final int DEFAULT_SUCCESS_EXIT_CODE = 0;
    public static final Predicate<String> DEFAULT_SUCCESS_START_CONDITION = line -> true;
    public static final boolean DEFAULT_NEED_STDOUT_IN_RESULT = true;
    public static final boolean DEFAULT_NEED_STDERR_IN_RESULT = true;
    public static final boolean DEFAULT_SHOW_FULL_RESULT_IN_EXCEPTION = false;

    public static Command of(String ... command) {
        return Command.of(command[0], Arrays.stream(command).skip(1L).collect(ImmutableList.toImmutableList()));
    }

    public static Command of(String executable, List<String> arguments) {
        return Command.newBuilder().executable(executable).arguments(arguments).build();
    }

    public static Command of(List<String> command) {
        return Command.newBuilder().executable(command.get(0)).arguments(command.subList(1, command.size())).build();
    }

    @CheckReturnValue
    public Command executable(String executable) {
        return this.toBuilder().executable(executable).build();
    }

    @CheckReturnValue
    public Command args(String ... arguments) {
        return this.args(ImmutableList.copyOf(arguments));
    }

    @CheckReturnValue
    public Command args(List<String> arguments) {
        return this.toBuilder().arguments(arguments).build();
    }

    @CheckReturnValue
    public Command argsAppended(String ... appendedArguments) {
        return this.argsAppended(ImmutableList.copyOf(appendedArguments));
    }

    @CheckReturnValue
    public Command argsAppended(List<String> appendedArguments) {
        return this.args((List<String>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builderWithExpectedSize(this.getArguments().size() + appendedArguments.size()).addAll(this.getArguments())).addAll(appendedArguments)).build()));
    }

    @CheckReturnValue
    public Command timeout(Timeout timeout) {
        return this.toBuilder().timeout(timeout).build();
    }

    @CheckReturnValue
    public Command timeout(CountDownTimer deadline) {
        return this.timeout(Timeout.deadline(deadline));
    }

    @CheckReturnValue
    public Command timeout(Instant deadline) {
        return this.timeout(Timeout.deadline(deadline));
    }

    @CheckReturnValue
    public Command timeout(Duration timeout) {
        return this.timeout(Timeout.fixed(timeout));
    }

    @CheckReturnValue
    public Command startTimeout(Timeout startTimeout) {
        return this.toBuilder().startTimeout(startTimeout).build();
    }

    @CheckReturnValue
    public Command startTimeout(CountDownTimer startDeadline) {
        return this.startTimeout(Timeout.deadline(startDeadline));
    }

    @CheckReturnValue
    public Command startTimeout(Instant startDeadline) {
        return this.startTimeout(Timeout.deadline(startDeadline));
    }

    @CheckReturnValue
    public Command startTimeout(Duration startTimeout) {
        return this.startTimeout(Timeout.fixed(startTimeout));
    }

    @CheckReturnValue
    public Command successfulStartCondition(Predicate<String> successfulStartCondition) {
        return this.toBuilder().successfulStartCondition(successfulStartCondition).build();
    }

    @CheckReturnValue
    public Command onTimeout(Runnable timeoutCallback) {
        return this.toBuilder().timeoutCallback(timeoutCallback).build();
    }

    @CheckReturnValue
    public Command onStdout(LineCallback stdoutLineCallback) {
        return this.toBuilder().stdoutLineCallback(stdoutLineCallback).build();
    }

    @CheckReturnValue
    public Command onStderr(LineCallback stderrLineCallback) {
        return this.toBuilder().stderrLineCallback(stderrLineCallback).build();
    }

    @CheckReturnValue
    public Command writeStdoutTo(Path path) {
        return this.toBuilder().stdoutPath(Optional.of(path)).build();
    }

    @CheckReturnValue
    public Command writeStderrTo(Path path) {
        return this.toBuilder().stderrPath(Optional.of(path)).build();
    }

    @CheckReturnValue
    public Command onExit(Consumer<CommandResult> resultConsumer) {
        return this.toBuilder().exitCallback(resultConsumer).build();
    }

    @CheckReturnValue
    public Command successExitCodes(int first, int ... rest) {
        return this.successExitCodes((Set<Integer>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add((Object)first)).addAll(Ints.asList(rest))).build()));
    }

    @CheckReturnValue
    public Command successExitCodes(Set<Integer> successExitCodes) {
        return this.toBuilder().successExitCodes(successExitCodes).build();
    }

    @CheckReturnValue
    public Command input(String input) {
        return this.toBuilder().input(input).build();
    }

    @CheckReturnValue
    public Command inputLn(String input) {
        return this.input(input + "\n");
    }

    @CheckReturnValue
    public Command workDir(Path workDirectory) {
        return this.toBuilder().workDirectory(workDirectory).build();
    }

    @CheckReturnValue
    public Command workDir(String workDirectory) {
        return this.workDir(Paths.get(workDirectory, new String[0]));
    }

    @CheckReturnValue
    public Command extraEnv(String k1, String v1, String ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "Odd number of key/value arguments: %s", (Object)Arrays.toString(rest));
        ImmutableMap.Builder<String, String> extraEnvironment = ImmutableMap.builder().put(k1, v1);
        for (int i = 0; i < rest.length; i += 2) {
            extraEnvironment.put(rest[i], rest[i + 1]);
        }
        return this.extraEnv(extraEnvironment.buildOrThrow());
    }

    @CheckReturnValue
    public Command extraEnv(Map<String, String> extraEnvironment) {
        return this.toBuilder().extraEnvironment(extraEnvironment).build();
    }

    @CheckReturnValue
    public Command redirectStderr(boolean redirectStderr) {
        return this.toBuilder().redirectStderr(redirectStderr).build();
    }

    @CheckReturnValue
    public Command needStdoutInResult(boolean needStdoutInResult) {
        return this.toBuilder().needStdoutInResult(needStdoutInResult).build();
    }

    @CheckReturnValue
    public Command needStderrInResult(boolean needStderrInResult) {
        return this.toBuilder().needStderrInResult(needStderrInResult).build();
    }

    @CheckReturnValue
    public Command showFullResultInException(boolean showFullResultInException) {
        return this.toBuilder().showFullResultInException(showFullResultInException).build();
    }

    public abstract String getExecutable();

    public abstract ImmutableList<String> getArguments();

    public abstract Optional<Timeout> getTimeout();

    public abstract Optional<Timeout> getStartTimeout();

    public abstract Predicate<String> getSuccessfulStartCondition();

    public abstract Optional<Runnable> getTimeoutCallback();

    public abstract Optional<LineCallback> getStdoutLineCallback();

    public abstract Optional<LineCallback> getStderrLineCallback();

    public abstract Optional<Path> getStdoutPath();

    public abstract Optional<Path> getStderrPath();

    public abstract Optional<Consumer<CommandResult>> getExitCallback();

    public abstract ImmutableSet<Integer> getSuccessExitCodes();

    public abstract Optional<String> getInput();

    public abstract Optional<Path> getWorkDirectory();

    public abstract ImmutableMap<String, String> getExtraEnvironment();

    public abstract Optional<Boolean> getRedirectStderr();

    public abstract boolean getNeedStdoutInResult();

    public abstract boolean getNeedStderrInResult();

    public abstract boolean getShowFullResultInException();

    @Memoized
    public ImmutableList<String> getCommand() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.getExecutable())).addAll(this.getArguments())).build();
    }

    @Memoized
    public String toString() {
        return String.join((CharSequence)" ", this.getCommand());
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Command)) {
            return false;
        }
        Command other = (Command)o;
        return this.getExecutable().equals(other.getExecutable()) && this.getArguments().equals(other.getArguments());
    }

    @Memoized
    public int hashCode() {
        return Objects.hash(this.getExecutable(), this.getArguments());
    }

    abstract Builder toBuilder();

    private static Builder newBuilder() {
        return new $AutoValue_Command.Builder().arguments(ImmutableList.of()).successfulStartCondition(DEFAULT_SUCCESS_START_CONDITION).successExitCodes(ImmutableSet.of(Integer.valueOf(0))).extraEnvironment(ImmutableMap.of()).needStdoutInResult(true).needStderrInResult(true).stderrPath(Optional.empty()).stdoutPath(Optional.empty()).showFullResultInException(false);
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder executable(String var1);

        abstract Builder arguments(List<String> var1);

        abstract Builder timeout(Timeout var1);

        abstract Builder startTimeout(Timeout var1);

        abstract Builder successfulStartCondition(Predicate<String> var1);

        abstract Builder timeoutCallback(Runnable var1);

        abstract Builder stdoutLineCallback(LineCallback var1);

        abstract Builder stderrLineCallback(LineCallback var1);

        abstract Builder stdoutPath(Optional<Path> var1);

        abstract Builder stderrPath(Optional<Path> var1);

        abstract Builder exitCallback(Consumer<CommandResult> var1);

        abstract Builder successExitCodes(Set<Integer> var1);

        abstract Builder input(String var1);

        abstract Builder workDirectory(Path var1);

        abstract Builder extraEnvironment(Map<String, String> var1);

        abstract Builder redirectStderr(boolean var1);

        abstract Builder needStdoutInResult(boolean var1);

        abstract Builder needStderrInResult(boolean var1);

        abstract Builder showFullResultInException(boolean var1);

        abstract Command build();
    }
}

