/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.base;

import com.google.common.annotations.GwtIncompatible;

@GwtIncompatible
public enum BinaryPrefix {
    UNIT(0),
    KIBI(1),
    MEBI(2),
    GIBI(3),
    TEBI(4),
    PEBI(5),
    EXBI(6);

    private static final long[] multipliers;
    private static final long[] overflows;
    private final int exponent;

    private BinaryPrefix(int exponent) {
        this.exponent = exponent;
    }

    public long convert(long sourceValue, BinaryPrefix sourcePrefix) {
        return this.doConvert(sourcePrefix.exponent - this.exponent, sourceValue);
    }

    private long doConvert(int delta, long value) {
        if (delta == 0) {
            return value;
        }
        if (delta < 0) {
            return value / multipliers[-delta];
        }
        if (value > overflows[delta]) {
            throw new ArithmeticException();
        }
        if (value < -overflows[delta]) {
            throw new ArithmeticException();
        }
        return value * multipliers[delta];
    }

    public static BinaryPrefix getLargestPrefix(long value) {
        if (value == 0L) {
            return UNIT;
        }
        if (Long.MIN_VALUE == value) {
            return EXBI;
        }
        long absValue = Math.abs(value);
        for (int i = 0; i < multipliers.length; ++i) {
            if (multipliers[i] <= absValue) continue;
            return BinaryPrefix.values()[i - 1];
        }
        return EXBI;
    }

    static {
        multipliers = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L, 0x1000000000000000L};
        overflows = new long[]{0L, 0x1FFFFFFFFFFFFFL, 0x7FFFFFFFFFFL, 0x1FFFFFFFFL, 0x7FFFFFL, 8191L, 7L};
    }
}

