/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite.retry;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.mobileharness.infra.ats.console.result.proto.ReportProto;
import com.google.devtools.mobileharness.platform.android.xts.common.TestStatus;
import com.google.devtools.mobileharness.platform.android.xts.suite.SuiteTestFilter;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RetryResultHelper {
    public static boolean shouldRunModule(ReportProto.Module module, Set<String> types, boolean addSubPlanCmd, ImmutableSet<String> passedInModules) {
        if (!addSubPlanCmd && !passedInModules.isEmpty()) {
            String moduleNameWithoutParam = module.getName();
            int moduleParamIdx = moduleNameWithoutParam.indexOf("[");
            if (moduleParamIdx > -1) {
                moduleNameWithoutParam = moduleNameWithoutParam.substring(0, moduleParamIdx);
            }
            if (!passedInModules.contains(moduleNameWithoutParam)) {
                return false;
            }
        }
        if (types.contains("not_executed") && !module.getDone()) {
            return true;
        }
        for (String status : RetryResultHelper.getStatusesToRun(types, addSubPlanCmd)) {
            if (RetryResultHelper.getNumTestsInState(module, status) <= 0L) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldRunEntireModule(ReportProto.Module module, Set<String> types, boolean addSubPlanCmd, Set<SuiteTestFilter> prevResultIncludeFilters, Set<SuiteTestFilter> prevResultExcludeFilters) {
        if (!types.contains("not_executed") && !module.getDone()) {
            return false;
        }
        Set<String> statusesToRun = RetryResultHelper.getStatusesToRun(types, addSubPlanCmd);
        for (TestStatus status : TestStatus.values()) {
            String statusStr = TestStatus.convertToTestStatusCompatibilityString(status);
            if (statusesToRun.contains(statusStr) || RetryResultHelper.getNumTestsInState(module, statusStr) <= 0L) continue;
            return false;
        }
        if (!prevResultIncludeFilters.isEmpty() && prevResultIncludeFilters.stream().anyMatch(filter -> filter.matchModule(module.getName(), module.getAbi(), null) && filter.testName().isPresent())) {
            return false;
        }
        return prevResultExcludeFilters.isEmpty() || !prevResultExcludeFilters.stream().anyMatch(filter -> filter.matchModule(module.getName(), module.getAbi(), null) && filter.testName().isPresent());
    }

    public static boolean shouldRunTest(ReportProto.Test test, Set<String> types, boolean addSubPlanCmd) {
        return RetryResultHelper.getStatusesToRun(types, addSubPlanCmd).contains(test.getResult());
    }

    private static long getNumTestsInState(ReportProto.Module module, String testStatus) {
        return module.getTestCaseList().stream().flatMap(testCase -> testCase.getTestList().stream()).filter(test -> Ascii.equalsIgnoreCase(test.getResult(), testStatus)).count();
    }

    private static Set<String> getStatusesToRun(Set<String> types, boolean addSubPlanCmd) {
        LinkedHashSet<String> statusesToRun = new LinkedHashSet<String>();
        if (addSubPlanCmd) {
            if (types.contains("passed")) {
                statusesToRun.add(TestStatus.convertToTestStatusCompatibilityString(TestStatus.PASSED));
            }
            if (types.contains("failed")) {
                statusesToRun.add(TestStatus.convertToTestStatusCompatibilityString(TestStatus.FAILURE));
            }
        } else {
            if (types.contains("failed")) {
                statusesToRun.add(TestStatus.convertToTestStatusCompatibilityString(TestStatus.FAILURE));
                statusesToRun.add(TestStatus.convertToTestStatusCompatibilityString(TestStatus.INCOMPLETE));
                statusesToRun.add(TestStatus.convertToTestStatusCompatibilityString(TestStatus.SKIPPED));
            }
            if (types.contains("not_executed")) {
                statusesToRun.add(TestStatus.convertToTestStatusCompatibilityString(TestStatus.INCOMPLETE));
                statusesToRun.add(TestStatus.convertToTestStatusCompatibilityString(TestStatus.SKIPPED));
            }
        }
        return statusesToRun;
    }

    private RetryResultHelper() {
    }
}

