/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite;

import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.devtools.mobileharness.platform.android.xts.suite.AutoValue_TestSuiteVersion;
import java.util.List;

@AutoValue
public abstract class TestSuiteVersion
implements Comparable<TestSuiteVersion> {
    public abstract int major();

    public abstract int minor();

    public abstract int patch();

    public abstract int revision();

    public static TestSuiteVersion create(String versionString) {
        boolean hasRevision;
        List<String> parts = Splitter.on('_').trimResults().omitEmptyStrings().splitToList(versionString);
        int major = 0;
        int minor = 0;
        int patch = 0;
        int revision = 0;
        boolean bl = hasRevision = parts.size() > 1;
        if (parts.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid version string: %s", versionString));
        }
        List<String> majorMinorPatch = Splitter.on('.').trimResults().omitEmptyStrings().splitToList(parts.get(0));
        if (majorMinorPatch.size() > 3) {
            throw new IllegalArgumentException(String.format("Invalid version string: %s", versionString));
        }
        if (majorMinorPatch.size() == 3) {
            patch = Integer.parseInt(majorMinorPatch.get(2));
        }
        if (majorMinorPatch.size() >= 2) {
            minor = Integer.parseInt(majorMinorPatch.get(1));
        }
        if (majorMinorPatch.size() >= 1) {
            major = Integer.parseInt(majorMinorPatch.get(0));
        }
        if (hasRevision) {
            String revisionString = parts.get(1);
            if (revisionString.startsWith("r") || revisionString.startsWith("R")) {
                revision = Integer.parseInt(revisionString.substring(1));
            } else {
                throw new IllegalArgumentException(String.format("Invalid revision in version string: %s", versionString));
            }
        }
        return TestSuiteVersion.create(major, minor, patch, revision);
    }

    public static TestSuiteVersion create(int major, int minor, int patch, int revision) {
        return new AutoValue_TestSuiteVersion(major, minor, patch, revision);
    }

    @Override
    public int compareTo(TestSuiteVersion otherVersion) {
        return ComparisonChain.start().compare(this.major(), otherVersion.major()).compare(this.minor(), otherVersion.minor()).compare(this.patch(), otherVersion.patch()).compare(this.revision(), otherVersion.revision()).result();
    }
}

