/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Splitter;
import com.google.devtools.mobileharness.platform.android.xts.common.util.AbiUtil;
import com.google.devtools.mobileharness.platform.android.xts.suite.AutoValue_SuiteTestFilter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@AutoValue
public abstract class SuiteTestFilter {
    private static final Splitter FILTER_STRING_SPLITTER = Splitter.on(' ').omitEmptyStrings();
    private static final Pattern PARAMETERIZED_MODULE_REGEX = Pattern.compile("(.*)\\[(.*)\\]$");

    public abstract String filterString();

    public abstract Optional<String> abi();

    public abstract String moduleName();

    public abstract Optional<String> testName();

    public static SuiteTestFilter create(String filterString) {
        List<String> tokens = FILTER_STRING_SPLITTER.splitToList(filterString);
        if (tokens.size() == 1) {
            return SuiteTestFilter.create(filterString, null, tokens.get(0), null);
        }
        if (AbiUtil.isAbiSupportedByCompatibility(tokens.get(0))) {
            String abi = tokens.get(0);
            String moduleName = tokens.get(1);
            String testName = "";
            if (tokens.size() > 2) {
                testName = String.join((CharSequence)" ", tokens.subList(2, tokens.size()));
            }
            return SuiteTestFilter.create(filterString, abi, moduleName, testName.isEmpty() ? null : testName);
        }
        String moduleName = tokens.get(0);
        String testName = "";
        if (tokens.size() > 1) {
            testName = String.join((CharSequence)" ", tokens.subList(1, tokens.size()));
        }
        return SuiteTestFilter.create(filterString, null, moduleName, testName.isEmpty() ? null : testName);
    }

    private static SuiteTestFilter create(String filterString, @Nullable String abi, String moduleName, @Nullable String testName) {
        return new AutoValue_SuiteTestFilter(filterString, Optional.ofNullable(abi), moduleName, Optional.ofNullable(testName));
    }

    public boolean matchModule(String originalModuleName, @Nullable String moduleAbi, @Nullable String moduleParameter) {
        String moduleName;
        String string = moduleName = moduleParameter == null ? originalModuleName : String.format("%s[%s]", originalModuleName, moduleParameter);
        if (!this.moduleName().equals(moduleName)) {
            return false;
        }
        if (this.abi().isEmpty()) {
            return true;
        }
        return this.abi().get().equals(moduleAbi);
    }

    public boolean matchModuleName(String moduleName) {
        return this.getBaseModuleName().equals(moduleName);
    }

    @Memoized
    public String toString() {
        return this.filterString();
    }

    private String getBaseModuleName() {
        Matcher matcher = PARAMETERIZED_MODULE_REGEX.matcher(this.moduleName());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return this.moduleName();
    }
}

