/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.suite;

import com.google.auto.value.AutoValue;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessExceptionFactory;
import com.google.devtools.mobileharness.platform.android.xts.suite.AutoValue_ModuleArg;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoValue
public abstract class ModuleArg {
    private static final String KEY_VALUE_SEPARATOR = ":=";
    private static final String FILE_KEY = "file";
    private static final Pattern MODULE_ARG_PATTERN = Pattern.compile("(?<moduleName>[^:\\[\\]]+(\\[.+\\])?):(?<argName>[^:]+):(?<argKeyValue>.+)");

    public abstract String moduleName();

    public abstract String argName();

    public abstract String argKey();

    public abstract String argValue();

    public static ModuleArg create(String moduleArgStr) throws MobileHarnessException {
        Matcher matcher = MODULE_ARG_PATTERN.matcher(moduleArgStr);
        if (!matcher.matches()) {
            throw MobileHarnessExceptionFactory.createUserFacingException(InfraErrorId.ATSC_INVALID_MODULE_ARG, String.format("Invalid module arg: %s, expected format '<module_name>:<arg_name>:[<arg_key>:=]<arg_value>'", moduleArgStr), null);
        }
        String moduleIdentifier = matcher.group("moduleName");
        String argName = matcher.group("argName");
        String[] keyValue = matcher.group("argKeyValue").split(KEY_VALUE_SEPARATOR, 2);
        if (keyValue.length == 1) {
            return new AutoValue_ModuleArg(moduleIdentifier, argName, "", keyValue[0]);
        }
        return new AutoValue_ModuleArg(moduleIdentifier, argName, keyValue[0], keyValue[1]);
    }

    public static boolean isValid(String moduleArgStr) {
        return MODULE_ARG_PATTERN.matcher(moduleArgStr).matches();
    }

    public boolean isFile() {
        return Objects.equals(this.argKey(), FILE_KEY);
    }
}

