/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.platform.android.xts.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.platform.android.xts.config.ConfigCommon;
import com.google.devtools.mobileharness.platform.android.xts.config.ConfigurationXmlParser;
import com.google.devtools.mobileharness.platform.android.xts.config.proto.ConfigurationProto;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ConfigurationUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final int CLASS_SEPARATOR = 46;
    private final LocalFileUtil localFileUtil = new LocalFileUtil();

    public ImmutableMap<String, ConfigurationProto.Configuration> getConfigsFromDirs(List<File> dirs) {
        ImmutableMap.Builder<String, ConfigurationProto.Configuration> configs = ImmutableMap.builder();
        Set<File> configFiles = this.getConfigFilesFromDirs(dirs);
        for (File configFile : configFiles) {
            try {
                configs.put(configFile.getAbsolutePath(), ConfigurationXmlParser.parse(configFile));
            }
            catch (MobileHarnessException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause(e)).log("Failed to parse %s", configFile.getAbsolutePath());
            }
        }
        return configs.buildOrThrow();
    }

    public ImmutableMap<String, ConfigurationProto.Configuration> getConfigsV2FromDirs(List<File> dirs) {
        ImmutableMap.Builder<String, ConfigurationProto.Configuration> configs = ImmutableMap.builder();
        Set<File> configFiles = this.getConfigFilesFromDirsByExt(dirs, ConfigCommon.CONFIG_V2_FILE_EXTENSIONS);
        for (File configFile : configFiles) {
            try {
                configs.put(configFile.getAbsolutePath(), ConfigurationXmlParser.parse(configFile));
            }
            catch (MobileHarnessException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).withCause(e)).log("Failed to parse %s", configFile.getAbsolutePath());
            }
        }
        return configs.buildOrThrow();
    }

    public ImmutableSet<String> getConfigPathsFromDirs(List<File> dirs) {
        return this.getConfigFilesFromDirs(dirs).stream().map(File::getAbsolutePath).collect(ImmutableSet.toImmutableSet());
    }

    public Set<File> getConfigFilesFromDirs(List<File> dirs) {
        return this.getConfigFilesFromDirsByExt(dirs, ConfigCommon.CONFIG_FILE_EXTENSIONS);
    }

    public Set<File> getConfigFilesFromDirsByExt(List<File> dirs, List<String> configFileExtensions) {
        FileFilter configFileFilter = file -> configFileExtensions.stream().anyMatch(extension -> file.getName().endsWith((String)extension));
        return this.getConfigFilesFromDirs(dirs, configFileFilter);
    }

    public Set<File> getConfigFilesFromDirs(List<File> dirs, FileFilter configFileFilter) {
        LinkedHashSet<File> configNames = new LinkedHashSet<File>();
        for (File dir : dirs) {
            File configDir = new File(dir.getAbsolutePath());
            if (!configDir.isDirectory()) {
                ((FluentLogger.Api)logger.atWarning()).log("%s doesn't exist or is not a directory.", configDir.getAbsolutePath());
                continue;
            }
            try {
                configNames.addAll(this.localFileUtil.listFiles(configDir.getAbsolutePath(), true, configFileFilter));
            }
            catch (MobileHarnessException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause(e)).log("Failed to get test config files from directory %s", configDir.getAbsolutePath());
            }
        }
        return this.dedupFiles(configNames);
    }

    private Set<File> dedupFiles(Set<File> originalConfigSet) {
        LinkedHashMap<String, File> configNameToFileMap = new LinkedHashMap<String, File>();
        for (File file : originalConfigSet) {
            configNameToFileMap.putIfAbsent(file.getName(), file);
        }
        return new LinkedHashSet<File>(configNameToFileMap.values());
    }

    public static ImmutableList<File> getConfigDirs(String xtsRootDir) {
        return ImmutableList.of(new File(xtsRootDir));
    }

    public static String getSimpleClassName(String clazz) {
        return clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    public Optional<File> getFileInDir(String fileName, File dir) throws MobileHarnessException {
        FileFilter fileFilter = file -> file.isFile() && file.getName().equals(fileName);
        List<File> files = this.localFileUtil.listFiles(dir.getAbsolutePath(), true, fileFilter);
        if (files.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(files.get(0));
    }
}

