/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.client.longrunningservice.util;

import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.SessionProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.SessionServiceProto;
import com.google.devtools.mobileharness.shared.util.message.FieldMaskUtils;
import com.google.protobuf.FieldMask;
import java.util.stream.Collectors;

public final class SessionQueryUtil {
    public static final FieldMask GET_SESSION_STATUS_FIELD_MASK = FieldMask.newBuilder().addPaths(FieldMaskUtils.createFieldMaskPath(SessionServiceProto.GetSessionResponse.getDescriptor().findFieldByNumber(1), SessionProto.SessionDetail.getDescriptor().findFieldByNumber(2))).build();
    public static final FieldMask SESSION_ID_FIELD_MASK = FieldMask.newBuilder().addPaths(FieldMaskUtils.createFieldMaskPath(SessionProto.SessionDetail.getDescriptor().findFieldByNumber(1))).build();
    public static final FieldMask SESSION_SUMMARY_FIELD_MASK = FieldMask.newBuilder().addPaths(FieldMaskUtils.createFieldMaskPath(SessionProto.SessionDetail.getDescriptor().findFieldByNumber(1))).addPaths(FieldMaskUtils.createFieldMaskPath(SessionProto.SessionDetail.getDescriptor().findFieldByNumber(2))).addPaths(FieldMaskUtils.createFieldMaskPath(SessionProto.SessionDetail.getDescriptor().findFieldByNumber(3), SessionProto.SessionConfig.getDescriptor().findFieldByNumber(1))).addPaths(FieldMaskUtils.createFieldMaskPath(SessionProto.SessionDetail.getDescriptor().findFieldByNumber(4), SessionProto.SessionOutput.getDescriptor().findFieldByNumber(1))).addPaths(FieldMaskUtils.createFieldMaskPath(SessionProto.SessionDetail.getDescriptor().findFieldByNumber(4), SessionProto.SessionOutput.getDescriptor().findFieldByNumber(4))).build();
    public static final String UNFINISHED_SESSION_STATUS_NAME_REGEX = ImmutableList.of(SessionProto.SessionStatus.SESSION_SUBMITTED, SessionProto.SessionStatus.SESSION_RUNNING).stream().map(Enum::name).collect(Collectors.joining("|"));
    public static final SessionServiceProto.SessionFilter UNFINISHED_NOT_ABORTED_SESSION_FILTER = SessionServiceProto.SessionFilter.newBuilder().setSessionStatusNameRegex(UNFINISHED_SESSION_STATUS_NAME_REGEX).addExcludedSessionPropertyKey("olc_server_session_aborted_when_running").build();
    public static final SessionServiceProto.SessionFilter UNFINISHED_SESSION_WITHOUT_STARTED_TEST_FILTER = SessionServiceProto.SessionFilter.newBuilder().setSessionStatusNameRegex(UNFINISHED_SESSION_STATUS_NAME_REGEX).addExcludedSessionPropertyKey("olc_server_session_contain_started_test").build();

    public static SessionServiceProto.SessionFilter getAllAbortableSessionFromClientFilter(String clientId) {
        return SessionQueryUtil.injectClientId(UNFINISHED_NOT_ABORTED_SESSION_FILTER, clientId);
    }

    public static SessionServiceProto.SessionFilter getUnfinishedSessionWithoutStartedTestFromClientFilter(String clientId) {
        return SessionQueryUtil.injectClientId(UNFINISHED_SESSION_WITHOUT_STARTED_TEST_FILTER, clientId);
    }

    public static SessionServiceProto.SessionFilter getAbortableSessionFromClientFilter(String commandId, String clientId) {
        SessionServiceProto.SessionFilter filter = UNFINISHED_NOT_ABORTED_SESSION_FILTER.toBuilder().putIncludedSessionProperty("olc_server_session_command_id", commandId).build();
        return SessionQueryUtil.injectClientId(filter, clientId);
    }

    public static SessionServiceProto.SessionFilter injectClientId(SessionServiceProto.SessionFilter sessionFilter, String clientId) {
        return sessionFilter.toBuilder().putIncludedSessionConfigProperty("olc_server_session_client_id", clientId).build();
    }

    private SessionQueryUtil() {
    }
}

