/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.util.console;

import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.infra.ats.console.Annotations;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleTextStyle;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import com.google.errorprone.annotations.FormatMethod;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jline.reader.LineReader;

@Singleton
public class ConsoleUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final ImmutableSet<String> HIDDEN_LOGGER_NAMES = ImmutableSet.of(ConsoleUtil.class.getName(), "com.google.protobuf.TextFormat");
    private final int minLogRecordImportance;
    private final LogHandler logHandler;
    @Nullable
    private final LineReader lineReader;
    private final boolean printAbove;

    @Inject
    ConsoleUtil(@Nullable @Annotations.ConsoleLineReader LineReader lineReader) {
        this.minLogRecordImportance = Flags.instance().atsConsoleMinLogRecordImportance.getNonNull();
        this.logHandler = new LogHandler();
        this.lineReader = lineReader;
        this.printAbove = Flags.instance().atsConsolePrintAboveInput.getNonNull();
    }

    @FormatMethod
    public void printlnStdout(String format, Object ... args) {
        String line = String.format(format, args);
        this.doPrintlnStdout(line);
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).logVarargs(format, args);
    }

    public void printlnStdout(String text) {
        this.doPrintlnStdout(text);
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("%s", text);
    }

    @FormatMethod
    public void printlnStderr(String format, Object ... args) {
        this.doPrintlnStderr(String.format(format, args));
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).logVarargs(format, args);
    }

    public void printlnStderr(String text) {
        this.doPrintlnStderr(text);
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("%s", text);
    }

    public void printlnDirect(String text, ConsoleTextStyle style, PrintStream secondaryStream) {
        if (this.printAbove) {
            if (!text.isEmpty() && this.lineReader != null) {
                style.printAbove(this.lineReader, text);
            }
        } else {
            secondaryStream.print(ConsoleUtil.addLineTerminatorIfNecessary(text));
        }
    }

    private void doPrintlnStdout(String text) {
        this.printlnDirect(text, ConsoleTextStyle.CONSOLE_STDOUT, System.out);
    }

    private void doPrintlnStderr(String text) {
        this.printlnDirect(text, ConsoleTextStyle.CONSOLE_STDERR, System.err);
    }

    public Handler getLogHandler() {
        return this.logHandler;
    }

    private static String addLineTerminatorIfNecessary(String line) {
        return line.endsWith("\n") || line.isEmpty() ? line : line + "\n";
    }

    private class LogHandler
    extends Handler {
        private LogHandler() {
            this.setFilter(record -> !HIDDEN_LOGGER_NAMES.contains(record.getLoggerName()) && LogRecordImportance.getLogRecordImportance(record, LogRecordImportance.LogImportanceScope.getCurrentScope()).value() >= ConsoleUtil.this.minLogRecordImportance);
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (this.isLoggable(logRecord)) {
                try {
                    String text = this.getFormatter().format(logRecord);
                    ConsoleUtil.this.doPrintlnStderr(text);
                }
                catch (RuntimeException e) {
                    this.reportError(null, e, 1);
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

