/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.controller.olcserver;

import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerEnvironmentPreparer;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.util.command.CommandHelper;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsCommandUtil;
import com.google.devtools.mobileharness.platform.android.xts.common.util.XtsDirUtil;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.file.local.LocalFileUtil;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;

public class XtsServerEnvironmentPreparer
implements ServerEnvironmentPreparer {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final ConsoleInfo consoleInfo;
    private final CommandHelper commandHelper;
    private final LocalFileUtil localFileUtil;

    @Inject
    XtsServerEnvironmentPreparer(ConsoleInfo consoleInfo, CommandHelper commandHelper, LocalFileUtil localFileUtil) {
        this.consoleInfo = consoleInfo;
        this.commandHelper = commandHelper;
        this.localFileUtil = localFileUtil;
    }

    @Override
    public ServerEnvironmentPreparer.ServerEnvironment prepareServerEnvironment() throws MobileHarnessException, InterruptedException {
        Path javaBinary;
        Path serverBinary;
        String xtsType = this.commandHelper.getXtsType();
        Path xtsRootDir = this.consoleInfo.getXtsRootDirectoryNonEmpty();
        Path initialServerBinary = Path.of(Flags.instance().atsConsoleOlcServerPath.getNonNull(), new String[0]);
        Path xtsServerResDirRoot = Path.of(Flags.instance().xtsServerResDirRoot.getNonNull(), new String[0]);
        Path serverWorkDir = xtsServerResDirRoot.resolve("olc_server_work");
        this.localFileUtil.prepareDir(serverWorkDir, new FileAttribute[0]);
        if (Flags.instance().atsConsoleOlcServerCopyServerResource.getNonNull().booleanValue()) {
            Path serverResDir = xtsServerResDirRoot.resolve("olc_server_res");
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Preparing xTS resource dir [%s]", serverResDir);
            this.localFileUtil.prepareDir(serverResDir, new FileAttribute[0]);
            this.grantFileOrDirFullAccess(serverResDir);
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Cleaning up xTS resource dir [%s]", serverResDir);
            this.localFileUtil.removeFilesOrDirs(serverResDir);
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Copying OLC server binary [%s] into xTS resource dir [%s]", (Object)initialServerBinary, (Object)serverResDir);
            this.localFileUtil.checkFile(initialServerBinary);
            this.localFileUtil.copyFileOrDir(initialServerBinary, serverResDir);
            serverBinary = serverResDir.resolve(initialServerBinary.getFileName());
            this.grantFileOrDirFullAccess(serverBinary);
            javaBinary = this.getJavaBinaryPath(xtsType, xtsRootDir, serverResDir);
        } else {
            serverBinary = initialServerBinary;
            javaBinary = this.getJavaBinaryPath(xtsType, xtsRootDir, null);
        }
        this.localFileUtil.checkFile(serverBinary);
        this.localFileUtil.checkFile(javaBinary);
        return ServerEnvironmentPreparer.ServerEnvironment.of(serverBinary, javaBinary, serverWorkDir);
    }

    private void grantFileOrDirFullAccess(Path path) {
        try {
            this.localFileUtil.grantFileOrDirFullAccess(path);
        }
        catch (MobileHarnessException e) {
            ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).withCause(e)).log("Failed to grant access to [%s]", path);
        }
    }

    private Path getJavaBinaryPath(String xtsType, Path xtsRootDir, Path serverResDir) throws MobileHarnessException, InterruptedException {
        if (!Flags.instance().xtsJdkDir.getNonNull().isEmpty()) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Use the JDK files from %s passed in via the flag --xts_jdk_dir for the server", Flags.instance().xtsJdkDir.getNonNull());
            Path jdkDir = Path.of(Flags.instance().xtsJdkDir.getNonNull(), new String[0]);
            this.grantFileOrDirFullAccess(jdkDir);
            return jdkDir.resolve("bin/java");
        }
        if (!Flags.instance().atsConsoleOlcServerCopyServerResource.getNonNull().booleanValue()) {
            return XtsCommandUtil.getJavaBinary(xtsType, xtsRootDir);
        }
        boolean useXtsJavaBinary = XtsCommandUtil.useXtsJavaBinary(xtsType, xtsRootDir);
        if (useXtsJavaBinary && serverResDir != null) {
            Path xtsJdkDir = XtsDirUtil.getXtsJdkDir(xtsRootDir, xtsType);
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Copying xTS JDK dir [%s] into xTS resource dir [%s]", (Object)xtsJdkDir, (Object)serverResDir);
            this.localFileUtil.checkDir(xtsJdkDir);
            this.localFileUtil.copyFileOrDir(xtsJdkDir, serverResDir);
            Path jdkDir = serverResDir.resolve(xtsJdkDir.getFileName());
            this.grantFileOrDirFullAccess(jdkDir);
            return jdkDir.resolve("bin/java");
        }
        return XtsCommandUtil.getJavaBinary(xtsType, xtsRootDir);
    }
}

