/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.controller.olcserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.devtools.common.metrics.stability.converter.ErrorModelConverter;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessExceptionFactory;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.Annotations;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerHeapDumpFileDetector;
import com.google.devtools.mobileharness.infra.ats.console.controller.proto.SessionPluginProto;
import com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.AtsSessionPluginConfigOutput;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.SessionProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.SessionServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.SessionStub;
import com.google.devtools.mobileharness.infra.client.longrunningservice.util.SessionQueryUtil;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.base.ProtoTextFormat;
import com.google.devtools.mobileharness.shared.util.concurrent.Callables;
import com.google.devtools.mobileharness.shared.util.time.Sleeper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.TextFormat;
import com.google.protobuf.TypeRegistry;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;

public class AtsSessionStub {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String SESSION_PLUGIN_LABEL = "AtsSessionPlugin";
    private static final String SESSION_PLUGIN_CLASS_NAME = "com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.AtsSessionPlugin";
    private static final String SESSION_PLUGIN_MODULE_CLASS_NAME = "com.google.devtools.mobileharness.infra.ats.console.controller.sessionplugin.AtsSessionPluginModule";
    private static final Duration GET_SESSION_STATUS_SHORT_INTERVAL = Duration.ofMillis(400L);
    private static final Duration GET_SESSION_STATUS_MEDIUM_INTERVAL = Duration.ofSeconds(5L);
    private static final Duration GET_SESSION_STATUS_LONG_INTERVAL = Duration.ofSeconds(30L);
    private static final TextFormat.Printer PRINTER = TextFormat.printer().usingTypeRegistry(TypeRegistry.newBuilder().add(ImmutableList.of(SessionPluginProto.AtsSessionPluginConfig.getDescriptor(), SessionPluginProto.AtsSessionPluginOutput.getDescriptor())).build());
    private final Provider<SessionStub> sessionStubProvider;
    private final String clientId;
    private final ListeningExecutorService threadPool;
    private final Sleeper sleeper;
    private final ServerHeapDumpFileDetector serverHeapDumpFileDetector;

    @Inject
    AtsSessionStub(@Annotations.ServerStub(value=Annotations.ServerStub.Type.SESSION_SERVICE) Provider<SessionStub> sessionStubProvider, @Annotations.ClientId String clientId, ListeningExecutorService threadPool, Sleeper sleeper, ServerHeapDumpFileDetector serverHeapDumpFileDetector) {
        this.sessionStubProvider = sessionStubProvider;
        this.clientId = clientId;
        this.threadPool = threadPool;
        this.sleeper = sleeper;
        this.serverHeapDumpFileDetector = serverHeapDumpFileDetector;
    }

    public ListenableFuture<SessionPluginProto.AtsSessionPluginOutput> runSession(String sessionName, SessionPluginProto.AtsSessionPluginConfig config) {
        SessionServiceProto.CreateSessionResponse createSessionResponse;
        SessionServiceProto.CreateSessionRequest createSessionRequest = SessionServiceProto.CreateSessionRequest.newBuilder().setSessionConfig(this.createSessionConfig(sessionName, config)).build();
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Creating session, plugin_config=[%s], request=[%s]", (Object)ProtoTextFormat.shortDebugString(config), (Object)ProtoTextFormat.shortDebugStringWithPrinter(createSessionRequest, PRINTER));
        try {
            createSessionResponse = Objects.requireNonNull(this.sessionStubProvider.get()).createSession(createSessionRequest);
        }
        catch (GrpcExceptionWithErrorId e) {
            this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
            return Futures.immediateFailedFuture(new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_CREATE_SESSION_ERROR, String.format("Failed to create session, request=[%s]", ProtoTextFormat.shortDebugStringWithPrinter(createSessionRequest, PRINTER)), e));
        }
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Session created, response=[%s]", ProtoTextFormat.shortDebugStringWithPrinter(createSessionResponse, PRINTER));
        SessionProto.SessionId sessionId = createSessionResponse.getSessionId();
        return this.threadPool.submit(Callables.threadRenaming(new GetAtsSessionTask(sessionId), () -> "get-ats-session-task-" + sessionId.getId()));
    }

    public SessionPluginProto.AtsSessionPluginOutput runShortSession(String sessionName, SessionPluginProto.AtsSessionPluginConfig config) throws MobileHarnessException {
        SessionServiceProto.RunSessionResponse runSessionResponse;
        SessionServiceProto.RunSessionRequest runSessionRequest = SessionServiceProto.RunSessionRequest.newBuilder().setSessionConfig(this.createSessionConfig(sessionName, config)).build();
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Running session, plugin_config=[%s], request=[%s]", (Object)ProtoTextFormat.shortDebugString(config), (Object)ProtoTextFormat.shortDebugStringWithPrinter(runSessionRequest, PRINTER));
        try {
            runSessionResponse = Objects.requireNonNull(this.sessionStubProvider.get()).runSession(runSessionRequest);
        }
        catch (GrpcExceptionWithErrorId e) {
            this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
            throw new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_RUN_SESSION_ERROR, String.format("Failed to run session, request=[%s]", ProtoTextFormat.shortDebugStringWithPrinter(runSessionRequest, PRINTER)), e);
        }
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Session finished, response=[%s]", ProtoTextFormat.shortDebugStringWithPrinter(runSessionResponse, PRINTER));
        return AtsSessionStub.getSessionPluginOutputForResult(runSessionResponse.getSessionDetail());
    }

    public ImmutableList<AtsSessionPluginConfigOutput> getAllUnfinishedSessions(String sessionNameRegex, boolean fromCurrentClient) throws MobileHarnessException {
        SessionServiceProto.SessionFilter filter = SessionServiceProto.SessionFilter.newBuilder().setSessionNameRegex(sessionNameRegex).setSessionStatusNameRegex(SessionQueryUtil.UNFINISHED_SESSION_STATUS_NAME_REGEX).build();
        SessionServiceProto.GetAllSessionsRequest getAllSessionsRequest = SessionServiceProto.GetAllSessionsRequest.newBuilder().setSessionFilter(fromCurrentClient ? SessionQueryUtil.injectClientId(filter, this.clientId) : filter).build();
        return this.getAllSessionOutputByRequest(getAllSessionsRequest);
    }

    private ImmutableList<AtsSessionPluginConfigOutput> getAllSessionOutputByRequest(SessionServiceProto.GetAllSessionsRequest getAllSessionsRequest) throws MobileHarnessException {
        SessionServiceProto.GetAllSessionsResponse getAllSessionsResponse = this.getAllSessionsByRequest(getAllSessionsRequest);
        return getAllSessionsResponse.getSessionDetailList().stream().flatMap(sessionDetail -> {
            try {
                SessionPluginProto.AtsSessionPluginConfig sessionPluginConfig = AtsSessionStub.getSessionPluginConfig(sessionDetail);
                Optional<SessionPluginProto.AtsSessionPluginOutput> sessionPluginOutput = AtsSessionStub.getSessionPluginOutputIfAny(sessionDetail);
                return Stream.of(AtsSessionPluginConfigOutput.of(sessionPluginConfig, sessionPluginOutput.orElse(null)));
            }
            catch (MobileHarnessException | RuntimeException e) {
                ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause(e)).log("Failed to get session plugin config/output, session=[%s]", ProtoTextFormat.shortDebugStringWithPrinter(sessionDetail, PRINTER));
                return Stream.empty();
            }
        }).collect(ImmutableList.toImmutableList());
    }

    private SessionServiceProto.GetAllSessionsResponse getAllSessionsByRequest(SessionServiceProto.GetAllSessionsRequest getAllSessionsRequest) throws MobileHarnessException {
        try {
            return Objects.requireNonNull(this.sessionStubProvider.get()).getAllSessions(getAllSessionsRequest);
        }
        catch (GrpcExceptionWithErrorId e) {
            this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
            throw new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_GET_ALL_SESSIONS_ERROR, String.format("Failed to get all sessions, request=[%s]", ProtoTextFormat.shortDebugString(getAllSessionsRequest)), e);
        }
    }

    public void abortUnstartedSessions() throws MobileHarnessException {
        SessionServiceProto.SessionFilter sessionFilter = SessionQueryUtil.getUnfinishedSessionWithoutStartedTestFromClientFilter(this.clientId);
        this.abortSessions(SessionServiceProto.AbortSessionsRequest.newBuilder().setSessionFilter(sessionFilter).build());
    }

    @CanIgnoreReturnValue
    private SessionServiceProto.AbortSessionsResponse abortSessions(SessionServiceProto.AbortSessionsRequest request) throws MobileHarnessException {
        try {
            SessionServiceProto.AbortSessionsResponse response = Objects.requireNonNull(this.sessionStubProvider.get()).abortSessions(request);
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Successfully aborted sessions, response=[%s]", ProtoTextFormat.shortDebugString(response));
            return response;
        }
        catch (GrpcExceptionWithErrorId e) {
            this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
            throw new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_ABORT_SESSION_ERROR, String.format("Failed to abort sessions, request=[%s]", ProtoTextFormat.shortDebugString(request)), e);
        }
    }

    public SessionServiceProto.NotifyAllSessionsResponse cancelSessionByCommandId(String commandId, SessionPluginProto.AtsSessionPluginNotification notification) throws MobileHarnessException {
        SessionServiceProto.SessionFilter sessionFilter = SessionQueryUtil.getAbortableSessionFromClientFilter(commandId, this.clientId);
        SessionServiceProto.NotifyAllSessionsRequest request = SessionServiceProto.NotifyAllSessionsRequest.newBuilder().setSessionFilter(sessionFilter).setSessionNotification(SessionProto.SessionNotification.newBuilder().setNotification(Any.pack(notification))).build();
        return this.cancelSessionsByNotification(request);
    }

    public void cancelUnfinishedNotAbortedSessions(boolean fromCurrentClient, SessionPluginProto.AtsSessionPluginNotification notification) throws MobileHarnessException {
        SessionServiceProto.SessionFilter sessionFilter = fromCurrentClient ? SessionQueryUtil.getAllAbortableSessionFromClientFilter(this.clientId) : SessionQueryUtil.UNFINISHED_NOT_ABORTED_SESSION_FILTER;
        SessionServiceProto.NotifyAllSessionsRequest request = SessionServiceProto.NotifyAllSessionsRequest.newBuilder().setSessionFilter(sessionFilter).setSessionNotification(SessionProto.SessionNotification.newBuilder().setNotification(Any.pack(notification))).build();
        this.cancelSessionsByNotification(request);
    }

    @CanIgnoreReturnValue
    private SessionServiceProto.NotifyAllSessionsResponse cancelSessionsByNotification(SessionServiceProto.NotifyAllSessionsRequest request) throws MobileHarnessException {
        try {
            SessionServiceProto.NotifyAllSessionsResponse response = Objects.requireNonNull(this.sessionStubProvider.get()).notifyAllSessions(request);
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Successfully notified sessions to cancel themselves, response=[%s]", ProtoTextFormat.shortDebugString(response));
            return response;
        }
        catch (GrpcExceptionWithErrorId e) {
            this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
            throw new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_CANCEL_UNFINISHED_SESSIONS_ERROR, String.format("Failed to cancel unfinished sessions, request=[%s]", ProtoTextFormat.shortDebugString(request)), e);
        }
    }

    private SessionProto.SessionConfig createSessionConfig(String sessionName, SessionPluginProto.AtsSessionPluginConfig config) {
        return SessionProto.SessionConfig.newBuilder().setSessionName(sessionName).putSessionProperty("olc_server_session_client_id", this.clientId).setSessionPluginConfigs(SessionProto.SessionPluginConfigs.newBuilder().addSessionPluginConfig(SessionProto.SessionPluginConfig.newBuilder().setLoadingConfig(SessionProto.SessionPluginLoadingConfig.newBuilder().setPluginClassName(SESSION_PLUGIN_CLASS_NAME).setPluginModuleClassName(SESSION_PLUGIN_MODULE_CLASS_NAME)).setExecutionConfig(SessionProto.SessionPluginExecutionConfig.newBuilder().setConfig(Any.pack(config))).setExplicitLabel(SessionProto.SessionPluginLabel.newBuilder().setLabel(SESSION_PLUGIN_LABEL)))).build();
    }

    private static Duration calculateGetSessionStatusInterval(int count) {
        if (count <= 100) {
            return GET_SESSION_STATUS_SHORT_INTERVAL;
        }
        if (count <= 300) {
            return GET_SESSION_STATUS_MEDIUM_INTERVAL;
        }
        return GET_SESSION_STATUS_LONG_INTERVAL;
    }

    private static SessionPluginProto.AtsSessionPluginConfig getSessionPluginConfig(SessionProto.SessionDetail sessionDetail) {
        return sessionDetail.getSessionConfig().getSessionPluginConfigs().getSessionPluginConfigList().stream().filter(sessionPluginConfig -> sessionPluginConfig.getExplicitLabel().getLabel().equals(SESSION_PLUGIN_LABEL)).map(sessionPluginConfig -> {
            try {
                return sessionPluginConfig.getExecutionConfig().getConfig().unpack(SessionPluginProto.AtsSessionPluginConfig.class);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException(e);
            }
        }).findFirst().orElseThrow();
    }

    private static SessionPluginProto.AtsSessionPluginOutput getSessionPluginOutputForResult(SessionProto.SessionDetail sessionDetail) throws MobileHarnessException {
        Optional<SessionPluginProto.AtsSessionPluginOutput> result = AtsSessionStub.getSessionPluginOutputIfAny(sessionDetail).filter(pluginOutput -> pluginOutput.getResultCase() != SessionPluginProto.AtsSessionPluginOutput.ResultCase.RESULT_NOT_SET);
        Optional<MobileHarnessException> sessionError = AtsSessionStub.getSessionError(sessionDetail);
        if (result.isPresent()) {
            sessionError.ifPresent(e -> ((FluentLogger.Api)((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).withCause((Throwable)e)).log("Warning of session %s:", sessionDetail.getSessionId().getId()));
            return result.get();
        }
        throw sessionError.orElseGet(() -> new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_ATS_SESSION_PLUGIN_NO_OUTPUT_ERROR, "ATS session plugin didn't set output"));
    }

    private static Optional<SessionPluginProto.AtsSessionPluginOutput> getSessionPluginOutputIfAny(SessionProto.SessionDetail sessionDetail) throws MobileHarnessException {
        SessionProto.SessionPluginOutput sessionPluginOutput = sessionDetail.getSessionOutput().getSessionPluginOutputMap().getOrDefault(SESSION_PLUGIN_LABEL, SessionProto.SessionPluginOutput.getDefaultInstance());
        if (sessionPluginOutput.hasOutput()) {
            try {
                return Optional.of(sessionPluginOutput.getOutput().unpack(SessionPluginProto.AtsSessionPluginOutput.class));
            }
            catch (InvalidProtocolBufferException e) {
                throw new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_UNPACK_SESSION_PLUGIN_OUTPUT_ERROR, "Failed to unpack AtsSessionPluginOutput", e);
            }
        }
        return Optional.empty();
    }

    private static Optional<MobileHarnessException> getSessionError(SessionProto.SessionDetail sessionDetail) {
        Optional sessionRunnerError = sessionDetail.hasSessionRunnerError() ? Optional.of(new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_SESSION_RUNNER_ERROR, "Session runner error", ErrorModelConverter.toDeserializedException(sessionDetail.getSessionRunnerError()))) : Optional.empty();
        List<SessionProto.SessionPluginError> sessionPluginErrors = sessionDetail.getSessionOutput().getSessionPluginErrorList();
        Map<Boolean, List<SessionProto.SessionPluginError>> sessionPluginErrorsPartitionedByLabel = sessionPluginErrors.stream().collect(Collectors.partitioningBy(error -> error.getPluginLabel().getLabel().equals(SESSION_PLUGIN_LABEL)));
        ImmutableList atsSessionPluginErrors = sessionPluginErrorsPartitionedByLabel.get(true).stream().map(atsSessionPluginError -> MobileHarnessExceptionFactory.createUserFacingException(InfraErrorId.ATSC_SESSION_STUB_ATS_SESSION_PLUGIN_ERROR, String.format("ATS session error, method=[%s]", atsSessionPluginError.getMethodName()), ErrorModelConverter.toDeserializedException(atsSessionPluginError.getError()))).collect(ImmutableList.toImmutableList());
        ImmutableList otherSessionPluginErrors = sessionPluginErrorsPartitionedByLabel.get(false).stream().map(otherSessionPluginError -> new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_OTHER_SESSION_PLUGIN_ERROR, String.format("Session plugin error, class=[%s], method=[%s]", otherSessionPluginError.getPluginClassName(), otherSessionPluginError.getMethodName()), ErrorModelConverter.toDeserializedException(otherSessionPluginError.getError()))).collect(ImmutableList.toImmutableList());
        ImmutableList sortedSessionErrors = Streams.concat(atsSessionPluginErrors.stream(), sessionRunnerError.stream(), otherSessionPluginErrors.stream()).collect(ImmutableList.toImmutableList());
        if (sortedSessionErrors.isEmpty()) {
            return Optional.empty();
        }
        MobileHarnessException result = (MobileHarnessException)sortedSessionErrors.get(0);
        sortedSessionErrors.stream().skip(1L).forEach(result::addSuppressed);
        return Optional.of(result);
    }

    private class GetAtsSessionTask
    implements Callable<SessionPluginProto.AtsSessionPluginOutput> {
        private final SessionProto.SessionId sessionId;

        private GetAtsSessionTask(SessionProto.SessionId sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public SessionPluginProto.AtsSessionPluginOutput call() throws MobileHarnessException, InterruptedException {
            SessionProto.SessionDetail sessionDetail;
            SessionProto.SessionStatus sessionStatus = SessionProto.SessionStatus.SESSION_STATUS_UNSPECIFIED;
            try {
                int count = 0;
                do {
                    AtsSessionStub.this.sleeper.sleep(AtsSessionStub.calculateGetSessionStatusInterval(++count));
                    SessionProto.SessionStatus newSessionStatus = Objects.requireNonNull(AtsSessionStub.this.sessionStubProvider.get()).getSession(SessionServiceProto.GetSessionRequest.newBuilder().setSessionId(this.sessionId).setFieldMask(SessionQueryUtil.GET_SESSION_STATUS_FIELD_MASK).build()).getSessionDetail().getSessionStatus();
                    if (newSessionStatus.equals(sessionStatus)) continue;
                    sessionStatus = newSessionStatus;
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atFine()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Session status: [%s], session_id=[%s]", (Object)sessionStatus, (Object)ProtoTextFormat.shortDebugString(this.sessionId));
                } while (!sessionStatus.equals(SessionProto.SessionStatus.SESSION_FINISHED));
            }
            catch (GrpcExceptionWithErrorId e) {
                AtsSessionStub.this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
                throw new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_GET_SESSION_STATUS_ERROR, String.format("Failed to get session status, session_id=[%s]", ProtoTextFormat.shortDebugString(this.sessionId)), e);
            }
            try {
                sessionDetail = Objects.requireNonNull(AtsSessionStub.this.sessionStubProvider.get()).getSession(SessionServiceProto.GetSessionRequest.newBuilder().setSessionId(this.sessionId).build()).getSessionDetail();
            }
            catch (GrpcExceptionWithErrorId e) {
                AtsSessionStub.this.serverHeapDumpFileDetector.detectHeapDumpExistenceWithGrpcError(e);
                throw new MobileHarnessException(InfraErrorId.ATSC_SESSION_STUB_GET_SESSION_RESULT_ERROR, String.format("Failed to get session result, session_id=[%s]", ProtoTextFormat.shortDebugString(this.sessionId)), e);
            }
            ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Session result: [%s]", ProtoTextFormat.shortDebugStringWithPrinter(sessionDetail, PRINTER));
            return AtsSessionStub.getSessionPluginOutputForResult(sessionDetail);
        }
    }
}

