/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.devtools.mobileharness.infra.ats.console.util.command.ExitUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.console.InterruptibleLineReader;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="kill", description={"Kills the console more aggressively."})
final class KillCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--force", "-f"}, required=false, paramLabel="<force_kill>", description={"Whether to quit the console immediately."})
    private boolean force = false;
    private final InterruptibleLineReader interruptibleLineReader;
    private final ExitUtil exitUtil;

    @Inject
    KillCommand(InterruptibleLineReader interruptibleLineReader, ExitUtil exitUtil) {
        this.interruptibleLineReader = interruptibleLineReader;
        this.exitUtil = exitUtil;
    }

    @Override
    public Integer call() {
        this.exitUtil.cancelUnfinishedSessions("User triggered Kill Command.", true);
        if (this.force) {
            this.interruptibleLineReader.interrupt();
        } else {
            ListenableFuture<?> listenableFuture = this.exitUtil.waitUntilNoRunningSessionsAndInterruptLineReader();
        }
        return 0;
    }
}

