/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console.command;

import com.google.devtools.mobileharness.infra.ats.console.command.alias.AliasManager;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import picocli.CommandLine;

@CommandLine.Command(name="alias", description={"Create an alias for a command. Usage: alias <alias_name>='<command>'."})
class AliasCommand
implements Callable<Integer> {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(index="0", arity="0..1", paramLabel="<alias_definition>", description={"The alias definition, e.g., my_alias='some command'"})
    private String aliasDefinition;
    private final AliasManager aliasManager;
    private final ConsoleUtil consoleUtil;
    private static final Pattern ALIAS_DEFINITION_PATTERN = Pattern.compile("(.+?)=['\"]?(.*?)['\"]?$");

    @Inject
    AliasCommand(AliasManager aliasManager, ConsoleUtil consoleUtil) {
        this.aliasManager = aliasManager;
        this.consoleUtil = consoleUtil;
    }

    @Override
    public Integer call() {
        if (this.aliasDefinition == null) {
            this.aliasManager.getAll().forEach((aliasName, aliasValue) -> this.consoleUtil.printlnStdout("alias %s='%s'", aliasName, aliasValue));
            return 0;
        }
        Matcher matcher = ALIAS_DEFINITION_PATTERN.matcher(this.aliasDefinition);
        if (!matcher.matches()) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid alias format. Expected: <alias_name>='<command>'");
        }
        String aliasName2 = matcher.group(1).trim();
        String aliasValue2 = matcher.group(2).trim();
        this.aliasManager.addAlias(aliasName2, aliasValue2);
        this.consoleUtil.printlnStdout("Alias '%s' created, value: [%s].", aliasName2, aliasValue2);
        return 0;
    }
}

