/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.console;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.common.metrics.stability.rpc.grpc.GrpcExceptionWithErrorId;
import com.google.devtools.mobileharness.api.model.error.InfraErrorId;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessException;
import com.google.devtools.mobileharness.api.model.error.MobileHarnessExceptionFactory;
import com.google.devtools.mobileharness.infra.ats.common.DeviceInfraServiceUtil;
import com.google.devtools.mobileharness.infra.ats.common.FlagsString;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.Annotations;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.BuiltinOlcServerFlags;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.OlcServerGrpcInProcessChannelModule;
import com.google.devtools.mobileharness.infra.ats.common.olcserver.ServerPreparer;
import com.google.devtools.mobileharness.infra.ats.console.Annotations;
import com.google.devtools.mobileharness.infra.ats.console.AtsConsoleModule;
import com.google.devtools.mobileharness.infra.ats.console.ConsoleInfo;
import com.google.devtools.mobileharness.infra.ats.console.GuiceFactory;
import com.google.devtools.mobileharness.infra.ats.console.command.RootCommand;
import com.google.devtools.mobileharness.infra.ats.console.command.completer.CommandCompleter;
import com.google.devtools.mobileharness.infra.ats.console.command.completer.CommandCompleterHolder;
import com.google.devtools.mobileharness.infra.ats.console.command.preprocessor.CommandPreprocessor;
import com.google.devtools.mobileharness.infra.ats.console.constant.AtsConsoleDirs;
import com.google.devtools.mobileharness.infra.ats.console.controller.olcserver.ServerLogPrinter;
import com.google.devtools.mobileharness.infra.ats.console.util.console.ConsoleUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.console.InterruptibleLineReader;
import com.google.devtools.mobileharness.infra.ats.console.util.log.LogDumper;
import com.google.devtools.mobileharness.infra.ats.console.util.log.LogRecordPrinter;
import com.google.devtools.mobileharness.infra.ats.console.util.notice.NoticeMessageUtil;
import com.google.devtools.mobileharness.infra.ats.console.util.version.VersionMessageUtil;
import com.google.devtools.mobileharness.infra.client.longrunningservice.OlcServerModuleFactory;
import com.google.devtools.mobileharness.infra.client.longrunningservice.OlcServerRunner;
import com.google.devtools.mobileharness.infra.client.longrunningservice.controller.LogRecorder;
import com.google.devtools.mobileharness.infra.client.longrunningservice.proto.ControlServiceProto;
import com.google.devtools.mobileharness.infra.client.longrunningservice.rpc.stub.ControlStub;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.constant.closeable.NonThrowingAutoCloseable;
import com.google.devtools.mobileharness.shared.util.concurrent.Callables;
import com.google.devtools.mobileharness.shared.util.flags.Flags;
import com.google.devtools.mobileharness.shared.util.inject.CommonModule;
import com.google.devtools.mobileharness.shared.util.logging.flogger.FloggerFormatter;
import com.google.devtools.mobileharness.shared.util.port.PortProber;
import com.google.devtools.mobileharness.shared.util.reflection.ReflectionUtil;
import com.google.devtools.mobileharness.shared.util.shell.ShellUtils;
import com.google.devtools.mobileharness.shared.util.system.SystemInfoPrinter;
import com.google.devtools.mobileharness.shared.util.time.Sleeper;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.wireless.qa.mobileharness.shared.MobileHarnessLogger;
import com.google.wireless.qa.mobileharness.shared.constant.DirPreparer;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.TerminalBuilder;
import picocli.CommandLine;

public class AtsConsole {
    private static final FluentLogger logger;
    private static final String HELP_PATTERN = "h|help";
    private static final String USE_NEW_OLC_SERVER_ENV_VAR = "USE_NEW_OLC_SERVER";
    private static final String USE_TF_RETRY_ENV_VAR = "USE_TF_RETRY";
    private static final String EMBEDDED_MODE_ENV_VAR = "OLC_SERVER_EMBEDDED_MODE";
    private static final String USE_NEW_PUBLIC_DIR_FOR_NEW_OLC_SERVER_ENV_VAR = "USE_NEW_PUBLIC_DIR_FOR_NEW_OLC_SERVER";
    private static final boolean DEFAULT_EMBEDDED_MODE = true;
    private static final boolean DEFAULT_USE_NEW_PUBLIC_DIR_FOR_NEW_OLC_SERVER = false;
    private static final String OLC_SERVER_CLASS_PATH = "ats_olc_server_local_mode_deploy.jar";
    private static final String OLC_SERVER_MODULE_FACTORY_IMPL_CLASS_NAME = "com.google.devtools.mobileharness.infra.client.longrunningservice.OlcServerModuleFactoryImpl";
    private final ImmutableList<String> mainArgs;
    private final FlagsString deviceInfraServiceFlags;
    private final LineReader lineReader;
    private final InterruptibleLineReader interruptibleLineReader;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final ControlStub controlStub;
    private final String clientId;
    private final Sleeper sleeper;
    private final ConsoleUtil consoleUtil;
    private final ConsoleInfo consoleInfo;
    private final LogRecordPrinter logRecordPrinter;
    private final ServerPreparer serverPreparer;
    private final ServerLogPrinter serverLogPrinter;
    private final SystemInfoPrinter systemInfoPrinter;
    private final VersionMessageUtil versionMessageUtil;
    private final CommandCompleter commandCompleter;
    private final CommandPreprocessor commandPreprocessor;
    private final OlcServerRunner olcServerRunner;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    @VisibleForTesting
    public volatile Injector injector;

    public static void main(String[] args) throws MobileHarnessException, IOException, InterruptedException {
        ImmutableMap<String, String> systemProperties = System.getProperties().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        FlagsString deviceInfraServiceFlags = DeviceInfraServiceUtil.getDeviceInfraServiceFlagsFromSystemProperty();
        FlagsString finalDeviceInfraServiceFlags = AtsConsole.preprocessDeviceInfraServiceFlags(deviceInfraServiceFlags);
        DeviceInfraServiceUtil.parseFlags(finalDeviceInfraServiceFlags.flags());
        System.out.println(NoticeMessageUtil.getNoticeMessage());
        DirPreparer.prepareDirRoots();
        MobileHarnessLogger.init(AtsConsoleDirs.getLogDir());
        LineReader lineReader = AtsConsole.createLineReader();
        ArrayList<AbstractModule> modules = new ArrayList<AbstractModule>();
        modules.add(new AtsConsoleModule("ats-console-" + String.valueOf(UUID.randomUUID()), finalDeviceInfraServiceFlags, Arrays.asList(args), systemProperties, lineReader, System.out, System.err, resultFuture -> {}, false));
        modules.add(new CommonModule());
        AtsConsole.createOlcServerModuleFactory().ifPresent(olcServerModuleFactory -> {
            Instant serverStartTime = Instant.now();
            Module olcServerModule = olcServerModuleFactory.create(Flags.instance().enableAtsMode.getNonNull(), serverStartTime, false, false, false);
            modules.add((AbstractModule)olcServerModule);
            modules.add(new OlcServerGrpcInProcessChannelModule());
        });
        Injector injector = Guice.createInjector(modules);
        AtsConsole atsConsole = injector.getInstance(AtsConsole.class);
        atsConsole.injector = injector;
        MobileHarnessLogger.addHandlers(ImmutableList.of(atsConsole.consoleUtil.getLogHandler()));
        MobileHarnessLogger.removeConsoleHandler();
        LogRecorder.getInstance().initialize(atsConsole.logRecordPrinter::printLogRecord);
        Runtime.getRuntime().addShutdownHook(new Thread(atsConsole::tryOnShutdown, "ats-console-shutdown-hook"));
        try (NonThrowingAutoCloseable ignored = Callables.threadRenaming("ats-console-main-thread");){
            atsConsole.run();
            atsConsole.tryOnShutdown();
            System.exit(0);
        }
        catch (MobileHarnessException | Error | InterruptedException | RuntimeException e2) {
            atsConsole.consoleUtil.printlnStderr("Console received an unexpected exception (shown below); shutting down ATS Console.\n%s", Throwables.getStackTraceAsString(e2));
            System.exit(1);
        }
    }

    @Inject
    AtsConsole(@Annotations.MainArgs ImmutableList<String> mainArgs, @Annotations.DeviceInfraServiceFlags FlagsString deviceInfraServiceFlags, @Annotations.ConsoleLineReader LineReader lineReader, InterruptibleLineReader interruptibleLineReader, @Annotations.ConsoleOutput(value=Annotations.ConsoleOutput.Type.OUT_WRITER) PrintWriter outWriter, @Annotations.ConsoleOutput(value=Annotations.ConsoleOutput.Type.ERR_WRITER) PrintWriter errWriter, @Annotations.ServerStub(value=Annotations.ServerStub.Type.CONTROL_SERVICE) ControlStub controlStub, @Annotations.ClientId String clientId, Sleeper sleeper, ConsoleUtil consoleUtil, ConsoleInfo consoleInfo, LogRecordPrinter logRecordPrinter, ServerPreparer serverPreparer, ServerLogPrinter serverLogPrinter, SystemInfoPrinter systemInfoPrinter, VersionMessageUtil versionMessageUtil, CommandCompleter commandCompleter, CommandPreprocessor commandPreprocessor, Optional<OlcServerRunner> olcServerRunner) {
        this.mainArgs = mainArgs;
        this.deviceInfraServiceFlags = deviceInfraServiceFlags;
        this.lineReader = lineReader;
        this.interruptibleLineReader = interruptibleLineReader;
        this.outWriter = outWriter;
        this.errWriter = errWriter;
        this.controlStub = controlStub;
        this.clientId = clientId;
        this.sleeper = sleeper;
        this.consoleUtil = consoleUtil;
        this.consoleInfo = consoleInfo;
        this.logRecordPrinter = logRecordPrinter;
        this.serverPreparer = serverPreparer;
        this.serverLogPrinter = serverLogPrinter;
        this.systemInfoPrinter = systemInfoPrinter;
        this.versionMessageUtil = versionMessageUtil;
        this.commandCompleter = commandCompleter;
        this.commandPreprocessor = commandPreprocessor;
        this.olcServerRunner = olcServerRunner.orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws MobileHarnessException, InterruptedException {
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("ATS console ID: %s", this.clientId);
        ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.DEBUG)).log("Flags: %s", this.deviceInfraServiceFlags.flags());
        this.systemInfoPrinter.printSystemInfo(LogRecordImportance.Importance.DEBUG);
        this.consoleUtil.printlnStdout(this.versionMessageUtil.getVersionMessage());
        this.consoleUtil.printlnStdout("Use \"help\" to get more information on running commands. Use \"dump bugreport\" to generate a debug info file. Log dirs: %s", LogDumper.getLogDirs(LogDumper.LogDirsType.USED));
        if (!this.mainArgs.isEmpty()) {
            this.consoleUtil.printlnStderr("Args: %s", this.mainArgs);
        }
        CommandCompleterHolder.getInstance().initialize(this.commandCompleter);
        this.commandCompleter.startListingTestPlans();
        if (Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            this.olcServerRunner.runBasic();
        }
        if (Flags.instance().enableAtsConsoleOlcServer.getNonNull().booleanValue()) {
            this.serverPreparer.prepareOlcServer();
            this.serverPreparer.startSendingHeartbeats();
        }
        if (Flags.instance().enableAtsConsoleOlcServerLog.getNonNull().booleanValue()) {
            this.serverLogPrinter.enable(true);
        }
        ImmutableList<String> args = this.mainArgs;
        block5: while (true) {
            ImmutableList<ImmutableList<String>> preprocessedCommands;
            CommandPreprocessor.PreprocessingResult preprocessingResult;
            ImmutableList<String> tokens;
            if (args.isEmpty()) {
                Optional<String> line = this.interruptibleLineReader.readLine();
                if (line.isEmpty()) break;
                try {
                    tokens = ShellUtils.tokenize(line.get());
                }
                catch (ShellUtils.TokenizationException e) {
                    this.consoleUtil.printlnStderr("Invalid input: %s", line.get());
                    continue;
                }
                if (tokens.isEmpty()) {
                    continue;
                }
            } else {
                this.consoleUtil.printlnStdout("Using commandline arguments as starting command: %s", args);
                this.lineReader.getHistory().add(Joiner.on(" ").join(args));
                tokens = args;
                args = ImmutableList.of();
                if (((String)tokens.get(0)).matches(HELP_PATTERN)) {
                    this.interruptibleLineReader.interrupt();
                }
            }
            if ((preprocessingResult = this.commandPreprocessor.preprocess(tokens)).errorMessage().isPresent()) {
                this.consoleUtil.printlnStderr(preprocessingResult.errorMessage().get());
                continue;
            }
            if (preprocessingResult.modifiedCommands().isPresent()) {
                preprocessedCommands = preprocessingResult.modifiedCommands().get();
                ((FluentLogger.Api)((FluentLogger.Api)logger.atInfo()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Replace command %s by %s", tokens, preprocessedCommands);
            } else {
                preprocessedCommands = ImmutableList.of(tokens);
            }
            this.consoleInfo.setFromCommandFile(preprocessingResult.isFromCommandFile());
            try {
                Iterator iterator = preprocessedCommands.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    ImmutableList command = (ImmutableList)iterator.next();
                    CommandLine commandLine = this.createCommandLine();
                    this.consoleInfo.setLastCommand(command);
                    commandLine.execute(command.toArray(new String[0]));
                    this.sleeper.sleep(Duration.ofMillis(100L));
                }
            }
            finally {
                this.consoleInfo.setFromCommandFile(false);
                continue;
            }
            break;
        }
        this.consoleUtil.printlnStderr("Input interrupted; quitting...");
    }

    private CommandLine createCommandLine() {
        return new CommandLine(RootCommand.class, new GuiceFactory(this.injector)).setCaseInsensitiveEnumValuesAllowed(true).setOut(this.outWriter).setErr(this.errWriter).setUnmatchedOptionsArePositionalParams(true);
    }

    private void tryOnShutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        System.out.println(LogDumper.dumpLog(LogDumper.LogDirsType.USED));
        if (Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            this.olcServerRunner.onShutdown();
        } else {
            try {
                this.controlStub.killServer(ControlServiceProto.KillServerRequest.newBuilder().setClientId(this.clientId).build());
            }
            catch (GrpcExceptionWithErrorId grpcExceptionWithErrorId) {
                // empty catch block
            }
        }
    }

    private static LineReader createLineReader() throws IOException {
        return LineReaderBuilder.builder().appName("AtsConsole").terminal(TerminalBuilder.builder().system(true).dumb(true).build()).history(new DefaultHistory()).completer(CommandCompleterHolder.getInstance()).build();
    }

    private static Optional<OlcServerModuleFactory> createOlcServerModuleFactory() throws MobileHarnessException {
        Class<OlcServerModuleFactory> olcServerModuleFactoryClass;
        if (!Flags.instance().atsConsoleOlcServerEmbeddedMode.getNonNull().booleanValue()) {
            return Optional.empty();
        }
        try {
            olcServerModuleFactoryClass = new ReflectionUtil().loadClass(OLC_SERVER_MODULE_FACTORY_IMPL_CLASS_NAME, OlcServerModuleFactory.class, AtsConsole.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Path olcServerFile;
            try {
                olcServerFile = Path.of(AtsConsole.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent().resolve(OLC_SERVER_CLASS_PATH);
            }
            catch (RuntimeException | URISyntaxException e2) {
                e.addSuppressed(e2);
                throw MobileHarnessExceptionFactory.createUserFacingException(InfraErrorId.ATSC_EMBEDDED_MODE_OLC_SERVER_JAR_NOT_FOUND, String.format("ATS console should have an OLC server jar [%s] in the same dir", OLC_SERVER_CLASS_PATH), e);
            }
            String olcServerFileAbsolutePath = olcServerFile.toAbsolutePath().toString();
            if (Files.exists(olcServerFile, new LinkOption[0])) {
                throw MobileHarnessExceptionFactory.createUserFacingException(InfraErrorId.ATSC_EMBEDDED_MODE_INVALID_OLC_SERVER_JAR, String.format("Invalid OLC server jar [%s]", olcServerFileAbsolutePath), e);
            }
            throw MobileHarnessExceptionFactory.createUserFacingException(InfraErrorId.ATSC_EMBEDDED_MODE_OLC_SERVER_JAR_NOT_FOUND, String.format("OLC server jar [%s] is not found in the dir of ATS console (%s)", OLC_SERVER_CLASS_PATH, olcServerFileAbsolutePath), null);
        }
        OlcServerModuleFactory olcServerModuleFactory = Guice.createInjector(new Module[0]).getInstance(olcServerModuleFactoryClass);
        return Optional.of(olcServerModuleFactory);
    }

    private static FlagsString preprocessDeviceInfraServiceFlags(FlagsString deviceInfraServiceFlags) throws IOException, InterruptedException {
        boolean useNewPublicDir;
        FlagsString flagsWithBuiltinFlags = deviceInfraServiceFlags.addToHead(BuiltinOlcServerFlags.get());
        ImmutableList.Builder extraFlags = ImmutableList.builder();
        boolean embeddedMode = System.getenv(EMBEDDED_MODE_ENV_VAR) == null ? true : Boolean.parseBoolean(System.getenv(EMBEDDED_MODE_ENV_VAR));
        boolean useNewOlcServer = Boolean.parseBoolean(System.getenv(USE_NEW_OLC_SERVER_ENV_VAR));
        boolean bl = useNewPublicDir = System.getenv(USE_NEW_PUBLIC_DIR_FOR_NEW_OLC_SERVER_ENV_VAR) == null ? false : Boolean.parseBoolean(System.getenv(USE_NEW_PUBLIC_DIR_FOR_NEW_OLC_SERVER_ENV_VAR));
        if (useNewOlcServer || embeddedMode) {
            extraFlags.addAll(AtsConsole.getRandomServerFlags(embeddedMode ? RandomServerType.PID : RandomServerType.PORT, useNewPublicDir));
        }
        extraFlags.add(String.format("--ats_console_olc_server_embedded_mode=%s", embeddedMode));
        if (System.getenv(USE_TF_RETRY_ENV_VAR) != null) {
            extraFlags.add(String.format("--use_tf_retry=%s", Boolean.parseBoolean(System.getenv(USE_TF_RETRY_ENV_VAR))));
        }
        return flagsWithBuiltinFlags.addToEnd((ImmutableList<String>)extraFlags.build());
    }

    private static ImmutableList<String> getRandomServerFlags(RandomServerType type, boolean randomPublicDir) throws IOException, InterruptedException {
        String serverId;
        ImmutableList.Builder result = ImmutableList.builder();
        if (type == RandomServerType.PORT) {
            int olcPort = PortProber.pickUnusedPort();
            result.add(String.format("--olc_server_port=%s", olcPort));
            serverId = Integer.toString(olcPort);
        } else {
            serverId = String.format("p%s", ProcessHandle.current().pid());
        }
        if (randomPublicDir) {
            result.add(String.format("--public_dir=/tmp/xts_console/server_%s", serverId));
        }
        return ((ImmutableList.Builder)result.add(new String[]{String.format("--tmp_dir_root=/tmp/xts_console/server_%s", serverId), "--ats_console_olc_server_copy_server_resource=false"})).build();
    }

    static {
        FloggerFormatter.initialize();
        logger = FluentLogger.forEnclosingClass();
    }

    private static enum RandomServerType {
        PORT,
        PID;

    }
}

