/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.infra.ats.common.plan;

import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.FluentLogger;
import com.google.devtools.mobileharness.shared.constant.LogRecordImportance;
import com.google.devtools.mobileharness.shared.util.error.MoreThrowables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarFileUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    public ImmutableMap<String, Path> getEntriesFromJars(List<Path> jars, EntryFilter filter) {
        HashMap<String, Path> entryNames = new HashMap<String, Path>();
        for (Path jar : jars) {
            try {
                entryNames.putAll(this.getEntriesFromJar(jar, filter));
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to get entries from jar %s: %s", (Object)jar, (Object)MoreThrowables.shortDebugString(e));
            }
        }
        return ImmutableMap.copyOf(entryNames);
    }

    private ImmutableMap<String, Path> getEntriesFromJar(Path jar, EntryFilter filter) throws IOException {
        try (JarFile jarFile = new JarFile(jar.toFile());){
            ImmutableMap.Builder<String, Path> entryNames = ImmutableMap.builder();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String entryName = ((ZipEntry)e.nextElement()).getName();
                if (!filter.accept(entryName)) continue;
                entryNames.put(filter.transform(entryName), jar);
            }
            ImmutableMap<String, Path> immutableMap = entryNames.buildOrThrow();
            return immutableMap;
        }
    }

    public Optional<InputStream> getZipEntryInputStream(Path jar, String entryName) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(jar.toFile());
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to open jar file %s: %s", (Object)jar, (Object)MoreThrowables.shortDebugString(e));
            return Optional.empty();
        }
        Optional<JarEntry> entry = jarFile.stream().filter(ze -> ze.getName().equals(entryName)).findFirst();
        if (entry.isEmpty()) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to load the entry [%s] from %s: file not found", (Object)entryName, (Object)jar);
            return Optional.empty();
        }
        try {
            return Optional.of(jarFile.getInputStream(entry.get()));
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).with(LogRecordImportance.IMPORTANCE, LogRecordImportance.Importance.IMPORTANT)).log("Failed to get input stream for entry %s in jar file %s: %s", entry, jar, MoreThrowables.shortDebugString(e));
            return Optional.empty();
        }
    }

    public static interface EntryFilter {
        public boolean accept(String var1);

        public String transform(String var1);
    }
}

