/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger;

import com.google.common.flogger.LogSiteKey;
import com.google.common.flogger.LogSiteMap;
import com.google.common.flogger.backend.Metadata;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class RateLimitStatus {
    public static final RateLimitStatus DISALLOW = RateLimitStatus.sentinel();
    public static final RateLimitStatus ALLOW = RateLimitStatus.sentinel();

    private static RateLimitStatus sentinel() {
        return new RateLimitStatus(){

            @Override
            public void reset() {
            }
        };
    }

    @NullableDecl
    static RateLimitStatus combine(@NullableDecl RateLimitStatus a, final @NullableDecl RateLimitStatus b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == DISALLOW || b == ALLOW) {
            return a;
        }
        if (b == DISALLOW || a == ALLOW) {
            return b;
        }
        return new RateLimitStatus(){

            @Override
            public void reset() {
                try {
                    RateLimitStatus.this.reset();
                }
                finally {
                    b.reset();
                }
            }
        };
    }

    static int checkStatus(RateLimitStatus status, LogSiteKey logSiteKey, Metadata metadata) {
        return LogGuard.checkAndGetSkippedCount(status, logSiteKey, metadata);
    }

    protected RateLimitStatus() {
    }

    protected abstract void reset();

    private static final class LogGuard {
        private static final LogSiteMap<LogGuard> guardMap = new LogSiteMap<LogGuard>(){

            @Override
            public LogGuard initialValue() {
                return new LogGuard();
            }
        };
        private final AtomicBoolean shouldReset = new AtomicBoolean();
        private final AtomicInteger pendingLogCount = new AtomicInteger();

        private LogGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int checkAndGetSkippedCount(RateLimitStatus status, LogSiteKey logSiteKey, Metadata metadata) {
            LogGuard guard = guardMap.get(logSiteKey, metadata);
            int pendingCount = guard.pendingLogCount.incrementAndGet();
            if (status == DISALLOW || !guard.shouldReset.compareAndSet(false, true)) {
                return -1;
            }
            try {
                status.reset();
            }
            finally {
                guard.shouldReset.set(false);
            }
            guard.pendingLogCount.addAndGet(-pendingCount);
            return pendingCount - 1;
        }
    }
}

