/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static String[] buildArray(String[] ... arrays) {
        int length = 0;
        for (String[] array : arrays) {
            length += array.length;
        }
        String[] newArray = new String[length];
        int offset = 0;
        for (String[] array : arrays) {
            System.arraycopy(array, 0, newArray, offset, array.length);
            offset += array.length;
        }
        return newArray;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... inputAry) {
        ArrayList<T> retList = new ArrayList<T>(inputAry.length);
        for (T item : inputAry) {
            retList.add(item);
        }
        return retList;
    }

    private static String internalJoin(String sep, Collection<Object> pieces) {
        StringBuilder sb = new StringBuilder();
        boolean skipSep = true;
        Iterator<Object> iter = pieces.iterator();
        while (iter.hasNext()) {
            if (skipSep) {
                skipSep = false;
            } else {
                sb.append(sep);
            }
            Object obj = iter.next();
            if (obj == null) {
                sb.append("null");
                continue;
            }
            sb.append(obj.toString());
        }
        return sb.toString();
    }

    public static String join(String sep, Object ... pieces) {
        if (pieces.length == 1 && pieces[0] instanceof Collection) {
            return ArrayUtil.internalJoin(sep, (Collection)pieces[0]);
        }
        return ArrayUtil.internalJoin(sep, Arrays.asList(pieces));
    }
}

