/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.ProcrankItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.ArrayUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcrankParser
implements IParser {
    private static final Pattern SHORT_LINE_PAT = Pattern.compile("\\s*(\\d+)\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\S+)");
    private static final Pattern LONG_LINE_PAT = Pattern.compile("\\s*(\\d+)\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\d+)K\\s+(\\S+)");
    private static final Pattern END_PAT = Pattern.compile("^(\\s+-{6}){3,}$");

    @Override
    public ProcrankItem parse(List<String> lines) {
        String text = ArrayUtil.join("\n", lines).replaceAll("\\s+$", "");
        if ("".equals(text.trim())) {
            return null;
        }
        ProcrankItem item = new ProcrankItem();
        item.setText(text);
        for (String line : lines) {
            Matcher endMatcher = END_PAT.matcher(line);
            if (endMatcher.matches()) {
                return item;
            }
            Matcher m = SHORT_LINE_PAT.matcher(line);
            if (m.matches()) {
                item.addProcrankLine(Integer.parseInt(m.group(1)), m.group(6), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)), Integer.parseInt(m.group(5)));
                continue;
            }
            m = LONG_LINE_PAT.matcher(line);
            if (!m.matches()) continue;
            item.addProcrankLine(Integer.parseInt(m.group(1)), m.group(10), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)), Integer.parseInt(m.group(5)));
        }
        return item;
    }
}

