/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.DvmLockSampleItem;
import com.android.loganalysis.parser.IParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DvmLockSampleParser
implements IParser {
    private static final String NAME_REGEX = "([^,]+)";
    private static final String FILE_REGEX = "(-|[A-Za-z]+\\.[A-Za-z]+)";
    private static final String INT_REGEX = "(\\d+)";
    private static final Pattern LOG_CONTENTION_EVENT_PATTERN = Pattern.compile("\\[" + String.join((CharSequence)",\\s*", Arrays.asList("([^,]+)", "(\\d+)", "([^,]+)", "(\\d+)", "(-|[A-Za-z]+\\.[A-Za-z]+)", "(\\d+)", "(-|[A-Za-z]+\\.[A-Za-z]+)", "(\\d+)", "(\\d+)")) + "\\]");
    private DvmLockSampleItem mItem = new DvmLockSampleItem();

    public DvmLockSampleItem parse(BufferedReader input) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = input.readLine();
        while (line != null) {
            lines.add(line);
            line = input.readLine();
        }
        return this.parse(lines);
    }

    @Override
    public DvmLockSampleItem parse(List<String> lines) {
        DvmLockSampleItem mItem = new DvmLockSampleItem();
        for (String line : lines) {
            Matcher m = LOG_CONTENTION_EVENT_PATTERN.matcher(line);
            if (!m.matches()) continue;
            mItem.setAttribute("PROCESS_NAME", m.group(1));
            mItem.setAttribute("SENSITIVITY_FLAG", 1 == Integer.parseInt(m.group(2)));
            mItem.setAttribute("WAITING_THREAD_NAME", m.group(3));
            mItem.setAttribute("WAIT_TIME", Integer.parseInt(m.group(4)));
            mItem.setAttribute("WAITING_SOURCE_FILE", m.group(5));
            mItem.setAttribute("WAITING_SOURCE_LINE", Integer.parseInt(m.group(6)));
            mItem.setAttribute("OWNER_FILE_NAME", m.group(7).equals("-") ? m.group(5) : m.group(7));
            mItem.setAttribute("OWNER_ACQUIRE_SOURCE_LINE", Integer.parseInt(m.group(8)));
            mItem.setAttribute("SAMPLE_PERCENTAGE", Integer.parseInt(m.group(9)));
        }
        System.out.println(mItem.toJson().toString());
        return mItem;
    }

    @VisibleForTesting
    DvmLockSampleItem getItem() {
        return this.mItem;
    }
}

