/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.IItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class GenericItem
implements IItem {
    private Map<String, Object> mAttributes = new HashMap<String, Object>();
    private Set<String> mAllowedAttributes = new HashSet<String>();

    protected GenericItem(Set<String> allowedAttributes) {
        this.mAllowedAttributes.addAll(allowedAttributes);
    }

    protected GenericItem(Set<String> allowedAttributes, Map<String, Object> attributes) {
        this(allowedAttributes);
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        if (this == other) {
            return this;
        }
        if (other == null || this.getClass() != other.getClass()) {
            throw new ConflictingItemException("Conflicting class types");
        }
        return new GenericItem(this.mAllowedAttributes, this.mergeAttributes(other, this.mAllowedAttributes));
    }

    protected Map<String, Object> mergeAttributes(IItem other, Set<String> attributes) throws ConflictingItemException {
        if (this == other) {
            return this.mAttributes;
        }
        if (other == null || this.getClass() != other.getClass()) {
            throw new ConflictingItemException("Conflicting class types");
        }
        GenericItem item = (GenericItem)other;
        HashMap<String, Object> mergedAttributes = new HashMap<String, Object>();
        for (String attribute : attributes) {
            mergedAttributes.put(attribute, GenericItem.mergeObjects(this.getAttribute(attribute), item.getAttribute(attribute)));
        }
        return mergedAttributes;
    }

    @Override
    public boolean isConsistent(IItem other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GenericItem item = (GenericItem)other;
        for (String attribute : this.mAllowedAttributes) {
            if (GenericItem.areConsistent(this.getAttribute(attribute), item.getAttribute(attribute))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GenericItem item = (GenericItem)other;
        for (String attribute : this.mAllowedAttributes) {
            if (GenericItem.areEqual(this.getAttribute(attribute), item.getAttribute(attribute))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 13;
        for (String attribute : this.mAllowedAttributes) {
            Object val = this.getAttribute(attribute);
            result += 37 * (val == null ? 0 : val.hashCode());
        }
        return result;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        for (Map.Entry<String, Object> entry : this.mAttributes.entrySet()) {
            String key = entry.getKey();
            Object attribute = entry.getValue();
            try {
                if (attribute != null && attribute instanceof IItem) {
                    object.put(key, (Object)((IItem)attribute).toJson());
                    continue;
                }
                object.put(key, attribute);
            }
            catch (JSONException jSONException) {}
        }
        return object;
    }

    protected void setAttribute(String attribute, Object value) throws IllegalArgumentException {
        if (!this.mAllowedAttributes.contains(attribute)) {
            throw new IllegalArgumentException();
        }
        this.mAttributes.put(attribute, value);
    }

    protected Object getAttribute(String attribute) throws IllegalArgumentException {
        if (!this.mAllowedAttributes.contains(attribute)) {
            throw new IllegalArgumentException();
        }
        return this.mAttributes.get(attribute);
    }

    protected static boolean areEqual(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    protected static boolean areConsistent(Object object1, Object object2) {
        return object1 == null || object2 == null ? true : object1.equals(object2);
    }

    protected static Object mergeObjects(Object object1, Object object2) throws ConflictingItemException {
        if (!GenericItem.areConsistent(object1, object2)) {
            throw new ConflictingItemException(String.format("%s conflicts with %s", object1, object2));
        }
        return object1 == null ? object2 : object1;
    }
}

