/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.IItem;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BatteryDischargeItem
implements IItem {
    public static final String BATTERY_DISCHARGE = "BATTERY_DISCHARGE";
    private Collection<BatteryDischargeInfoItem> mBatteryDischargeInfo = new LinkedList<BatteryDischargeInfoItem>();

    public void addBatteryDischargeInfo(Calendar clockTime, long elapsedTime, int batteryLevel) {
        this.mBatteryDischargeInfo.add(new BatteryDischargeInfoItem(clockTime, elapsedTime, batteryLevel));
    }

    public Collection<BatteryDischargeInfoItem> getDischargeStepsInfo() {
        return this.mBatteryDischargeInfo;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Wakelock items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        try {
            JSONArray batteryDischargeSteps = new JSONArray();
            for (BatteryDischargeInfoItem batteryDischargeStep : this.mBatteryDischargeInfo) {
                batteryDischargeSteps.put((Object)batteryDischargeStep.toJson());
            }
            object.put(BATTERY_DISCHARGE, (Object)batteryDischargeSteps);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object;
    }

    public static class BatteryDischargeInfoItem
    extends GenericItem {
        public static final String CLOCK_TIME_OF_DISCHARGE = "CLOCK_TIME_OF_DISCHARGE";
        public static final String DISCHARGE_ELAPSED_TIME = "DISCHARGE_ELAPSED_TIME";
        public static final String BATTERY_LEVEL = "BATTERY_LEVEL";
        private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("CLOCK_TIME_OF_DISCHARGE", "DISCHARGE_ELAPSED_TIME", "BATTERY_LEVEL"));

        public BatteryDischargeInfoItem(Calendar clockTime, long elapsedTime, int batteryLevel) {
            super(ATTRIBUTES);
            this.setAttribute(CLOCK_TIME_OF_DISCHARGE, clockTime);
            this.setAttribute(DISCHARGE_ELAPSED_TIME, elapsedTime);
            this.setAttribute(BATTERY_LEVEL, batteryLevel);
        }

        public Calendar getClockTime() {
            return (Calendar)this.getAttribute(CLOCK_TIME_OF_DISCHARGE);
        }

        public long getElapsedTime() {
            return (Long)this.getAttribute(DISCHARGE_ELAPSED_TIME);
        }

        public int getBatteryLevel() {
            return (Integer)this.getAttribute(BATTERY_LEVEL);
        }
    }
}

