/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.tradefed.config.Option;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OptionHelper {
    private OptionHelper() {
    }

    private static List<Field> getFields(Object object) {
        Field[] classFields = object.getClass().getDeclaredFields();
        ArrayList<Field> optionFields = new ArrayList<Field>();
        for (Field declaredField : classFields) {
            declaredField.setAccessible(true);
            if (!declaredField.isAnnotationPresent(Option.class)) continue;
            optionFields.add(declaredField);
        }
        return optionFields;
    }

    static Set<String> getOptionNames(Object object) {
        HashSet<String> options = new HashSet<String>();
        List<Field> optionFields = OptionHelper.getFields(object);
        for (Field declaredField : optionFields) {
            Option option = declaredField.getAnnotation(Option.class);
            options.add(option.name());
        }
        return options;
    }

    static Set<String> getOptionShortNames(Object object) {
        HashSet<String> shortNames = new HashSet<String>();
        List<Field> optionFields = OptionHelper.getFields(object);
        for (Field declaredField : optionFields) {
            Option option = declaredField.getAnnotation(Option.class);
            if (option.shortName() == '0') continue;
            shortNames.add(String.valueOf(option.shortName()));
        }
        return shortNames;
    }

    public static List<String> getValidCliArgs(String commandString, Object object) {
        Set<String> optionNames = OptionHelper.getOptionNames(object);
        Set<String> optionShortNames = OptionHelper.getOptionShortNames(object);
        ArrayList<String> validCliArgs = new ArrayList<String>();
        String quoteMatching = "(\"[^\"]+\")";
        String nonSpacedHypen = "((?<!\\s)-(?!\\s))";
        Pattern cliPattern = Pattern.compile("((-[-\\w]+([ =](" + quoteMatching + "|([\\w\\/\\s:=.]|" + nonSpacedHypen + ")+))?))|" + quoteMatching);
        Matcher matcher = cliPattern.matcher(commandString);
        while (matcher.find()) {
            String optionInput = OptionHelper.cleanNameValueDelimiter(matcher.group());
            String[] keyNameTokens = optionInput.split("[ =]", 2);
            String keyName = keyNameTokens[0].replaceFirst("^\"?--?", "");
            if (optionInput.charAt(0) == '\"') {
                optionInput = keyNameTokens[0].substring(1) + " \"" + keyNameTokens[1];
            }
            if (!optionShortNames.contains(keyName) && !optionNames.contains(keyName)) continue;
            Pattern tokenPattern = Pattern.compile("(\".*\")|[^\\s]+");
            Matcher tokenMatcher = tokenPattern.matcher(optionInput);
            while (tokenMatcher.find()) {
                String token = tokenMatcher.group().replaceAll("\"", "");
                validCliArgs.add(token);
            }
        }
        return validCliArgs;
    }

    private static String cleanNameValueDelimiter(String optionNameValue) {
        return optionNameValue.replaceFirst("[ =]", " ");
    }
}

