/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.util.DynamicConfig;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class DynamicConfigFileReader {
    public static String getValueFromConfig(File file, String key) throws XmlPullParserException, IOException {
        DynamicConfig config = new DynamicConfig();
        config.initializeConfig(file);
        return config.getValue(key);
    }

    public static List<String> getValuesFromConfig(File file, String key) throws XmlPullParserException, IOException {
        DynamicConfig config = new DynamicConfig();
        config.initializeConfig(file);
        return config.getValues(key);
    }

    public static String getValueFromConfig(IBuildInfo info, String moduleName, String key) throws XmlPullParserException, IOException {
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(info);
        File dynamicConfig = helper.getDynamicConfigFiles().get(moduleName);
        if (dynamicConfig == null) {
            LogUtil.CLog.w((String)"Config file %s, not found in the map of dynamic configs.", (Object[])new Object[]{moduleName});
            return null;
        }
        return DynamicConfigFileReader.getValueFromConfig(dynamicConfig, key);
    }

    public static List<String> getValuesFromConfig(IBuildInfo info, String moduleName, String key) throws XmlPullParserException, IOException {
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(info);
        File dynamicConfig = helper.getDynamicConfigFiles().get(moduleName);
        if (dynamicConfig == null) {
            String message = String.format("Dynamic config file %s, not found in the map of configured dynamic configs.", moduleName);
            LogUtil.CLog.w((String)message);
            throw new HarnessRuntimeException(message, (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        return DynamicConfigFileReader.getValuesFromConfig(dynamicConfig, key);
    }

    public static List<String> getValuesFromConfig(IBuildInfo info, List<String> suiteNames, String key) throws XmlPullParserException, IOException {
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(info);
        Map<String, File> dynamicConfigFiles = helper.getDynamicConfigFiles();
        LogUtil.CLog.i((String)"config files: %s", (Object[])new Object[]{dynamicConfigFiles});
        for (String suiteName : suiteNames) {
            File dynamicConfig = dynamicConfigFiles.get(suiteName);
            if (dynamicConfig == null) continue;
            return DynamicConfigFileReader.getValuesFromConfig(dynamicConfig, key);
        }
        String message = String.format("Dynamic config files %s, not found in the map of configured dynamic configs: %s", suiteNames, dynamicConfigFiles);
        LogUtil.CLog.w((String)message);
        throw new HarnessRuntimeException(message, (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
    }
}

