/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

public final class BuildFingerPrintPreparer
extends BaseTargetPreparer {
    @Option(name="expected-fingerprint")
    private String mExpectedFingerprint = null;
    @Option(name="expected-vendor-fingerprint")
    private String mExpectedVendorFingerprint = null;
    @Option(name="unaltered-fingerprint")
    private String mUnalteredFingerprint = null;
    private String mFingerprintProperty = "ro.build.fingerprint";
    private String mVendorFingerprintProperty = "ro.vendor.build.fingerprint";

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        if (this.mExpectedFingerprint == null) {
            throw new TargetSetupError("build fingerprint shouldn't be null", device.getDeviceDescriptor());
        }
        try {
            String currentBuildFingerprint;
            String compare = this.mExpectedFingerprint;
            if (this.mUnalteredFingerprint != null) {
                compare = this.mUnalteredFingerprint;
            }
            if (!compare.equals(currentBuildFingerprint = device.getProperty(this.mFingerprintProperty))) {
                throw new TargetSetupError(String.format("Device build fingerprint must match '%s'. Found '%s' instead.", compare, currentBuildFingerprint), device.getDeviceDescriptor());
            }
            if (this.mExpectedVendorFingerprint != null) {
                String currentBuildVendorFingerprint = device.getProperty(this.mVendorFingerprintProperty);
                if (currentBuildVendorFingerprint == null) {
                    currentBuildVendorFingerprint = "";
                }
                if (!this.mExpectedVendorFingerprint.equals(currentBuildVendorFingerprint)) {
                    throw new TargetSetupError(String.format("Device vendor build fingerprint must match '%s'. Found '%s' instead.", this.mExpectedVendorFingerprint, currentBuildVendorFingerprint), device.getDeviceDescriptor());
                }
            }
        }
        catch (DeviceNotAvailableException e) {
            throw new RuntimeException(e);
        }
    }

    public void setExpectedFingerprint(String expectedFingerprint) {
        this.mExpectedFingerprint = expectedFingerprint;
    }

    public String getExpectedFingerprint() {
        return this.mExpectedFingerprint;
    }

    public void setFingerprintProperty(String property) {
        this.mFingerprintProperty = property;
    }

    public void setUnalteredFingerprint(String unalteredFingerprint) {
        this.mUnalteredFingerprint = unalteredFingerprint;
    }

    public void setExpectedVendorFingerprint(String expectedVendorFingerprint) {
        this.mExpectedVendorFingerprint = expectedVendorFingerprint;
    }
}

