/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.loading;

import com.android.tradefed.build.FolderBuildInfo;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.RootTargetPreparer;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.testtype.suite.params.ModuleParameters;
import com.android.tradefed.util.FileUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CtsConfigLoadingTest {
    private static final String METADATA_COMPONENT = "component";
    private static final Set<String> KNOWN_COMPONENTS = new HashSet<String>(Arrays.asList("adservices", "art", "auth", "auto", "autofill", "backup", "bionic", "bluetooth", "camera", "contentcapture", "deviceinfo", "deqp", "devtools", "framework", "graphics", "hdmi", "inputmethod", "libcore", "location", "media", "metrics", "misc", "mocking", "networking", "neuralnetworks", "nfc", "packagemanager", "permissions", "print", "renderscript", "security", "statsd", "systems", "sysui", "telecom", "threadnetwork", "tv", "uitoolkit", "uwb", "vr", "webview", "wifi"));
    private static final Set<String> KNOWN_MISC_MODULES = new HashSet<String>(Arrays.asList("CtsSliceTestCases.config", "CtsSampleDeviceTestCases.config", "CtsUsbTests.config", "CtsGpuToolsHostTestCases.config", "CtsEdiHostTestCases.config", "CtsClassLoaderFactoryPathClassLoaderTestCases.config", "CtsSampleHostTestCases.config", "CtsHardwareTestCases.config", "CtsAndroidAppTestCases.config", "CtsClassLoaderFactoryInMemoryDexClassLoaderTestCases.config", "CtsAppComponentFactoryTestCases.config", "CtsSeccompHostTestCases.config"));
    private static final Set<String> MANDATORY_PARAMETERS_FAMILY = new HashSet<String>();
    private static final Set<String> ALLOWLIST_MODULE_PARAMETERS;

    @Test
    public void testConfigurationLoad() throws Exception {
        File testcases;
        String rootVar = String.format("%s_ROOT", this.getSuiteName().toUpperCase());
        String suiteRoot = System.getProperty(rootVar);
        if (Strings.isNullOrEmpty((String)suiteRoot)) {
            Assert.fail((String)String.format("Should run within a suite context: %s doesn't exist", rootVar));
        }
        if (!(testcases = new File(suiteRoot, String.format("/android-%s/testcases/", this.getSuiteName().toLowerCase()))).exists()) {
            Assert.fail((String)String.format("%s does not exists", testcases));
            return;
        }
        Set listConfigs = FileUtil.findFilesObject((File)testcases, (String)".*\\.config");
        Assert.assertTrue((listConfigs.size() > 0 ? 1 : 0) != 0);
        FolderBuildInfo stubFolder = new FolderBuildInfo("-1", "-1");
        stubFolder.setRootDir(new File(suiteRoot));
        stubFolder.addBuildAttribute("SUITE_NAME", this.getSuiteName().toUpperCase());
        stubFolder.addBuildAttribute("ROOT_DIR", suiteRoot);
        TestInformation stubTestInfo = TestInformation.newBuilder().setInvocationContext((IInvocationContext)new InvocationContext()).build();
        stubTestInfo.executionFiles().put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, new File(suiteRoot));
        ArrayList<String> missingMandatoryParameters = new ArrayList<String>();
        for (File config : listConfigs) {
            boolean res;
            IConfiguration c = ConfigurationFactory.getInstance().createConfigurationFromArgs(new String[]{config.getAbsolutePath()});
            ConfigurationDescriptor cd = c.getConfigurationDescription();
            Assert.assertNotNull((String)(config + ": configuration descriptor is null"), (Object)cd);
            List component = cd.getMetaData(METADATA_COMPONENT);
            Assert.assertNotNull((String)String.format("Missing module metadata field \"component\", please add the following line to your AndroidTest.xml:\n<option name=\"config-descriptor:metadata\" key=\"component\" value=\"...\" />\nwhere \"value\" must be one of: %s\nconfig: %s", KNOWN_COMPONENTS, config), (Object)component);
            Assert.assertEquals((String)String.format("Module config contains more than one \"component\" metadata field: %s\nconfig: %s", component, config), (long)1L, (long)component.size());
            String cmp = (String)component.get(0);
            Assert.assertTrue((String)String.format("Module config contains unknown \"component\" metadata field \"%s\", supported ones are: %s\nconfig: %s", cmp, KNOWN_COMPONENTS, config), (boolean)KNOWN_COMPONENTS.contains(cmp));
            if ("misc".equals(cmp)) {
                String configFileName = config.getName();
                Assert.assertTrue((String)String.format("Adding new module %s to \"misc\" component is restricted, please pick a component that your module fits in", configFileName), (boolean)KNOWN_MISC_MODULES.contains(configFileName));
            }
            if (!(res = this.checkModuleParameters(config.getName(), cd.getMetaData("parameter")))) {
                missingMandatoryParameters.add(config.getName());
            }
            String suiteName = this.getSuiteName().toLowerCase();
            Assert.assertTrue((String)String.format("Module config %s does not contains '<option name=\"test-suite-tag\" value=\"%s\" />'", config.getName(), suiteName), (boolean)cd.getSuiteTags().contains(suiteName));
            for (IDeviceConfiguration dConfig : c.getDeviceConfig()) {
                for (ITargetPreparer prep : dConfig.getTargetPreparers()) {
                    if (!prep.getClass().isAssignableFrom(RootTargetPreparer.class) || !((RootTargetPreparer)prep).shouldForceRoot() || !((RootTargetPreparer)prep).shouldThrowOnFailure()) continue;
                    throw new ConfigurationException(String.format("%s: Usage of root in CTS is forbidden.", config));
                }
            }
            c.validateOptions();
        }
        missingMandatoryParameters.removeAll(ALLOWLIST_MODULE_PARAMETERS);
        if (!missingMandatoryParameters.isEmpty()) {
            String msg = String.format("The following %s modules are missing some of the mandatory parameters [instant_app, not_instant_app, multi_abi, not_multi_abi, secondary_user, not_secondary_user]: '%s'", missingMandatoryParameters.size(), missingMandatoryParameters);
            throw new ConfigurationException(msg);
        }
    }

    private boolean checkModuleParameters(String configName, List<String> parameters) throws ConfigurationException {
        if (parameters == null) {
            return false;
        }
        Map<String, Boolean> families = this.createFamilyCheckMap();
        for (String param : parameters) {
            try {
                ModuleParameters p = ModuleParameters.valueOf((String)param.toUpperCase());
                if (!families.containsKey(p.getFamily())) continue;
                families.put(p.getFamily(), true);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("Config: %s includes an unknown parameter '%s'.", configName, param));
            }
        }
        return !families.containsValue(false);
    }

    private Map<String, Boolean> createFamilyCheckMap() {
        HashMap<String, Boolean> families = new HashMap<String, Boolean>();
        for (String family : MANDATORY_PARAMETERS_FAMILY) {
            families.put(family, false);
        }
        return families;
    }

    private String getSuiteName() {
        return TestSuiteInfo.getInstance().getName();
    }

    static {
        MANDATORY_PARAMETERS_FAMILY.add("instant_app_family");
        MANDATORY_PARAMETERS_FAMILY.add("multi_abi_family");
        MANDATORY_PARAMETERS_FAMILY.add("secondary_user_family");
        ALLOWLIST_MODULE_PARAMETERS = new HashSet<String>();
    }
}

