/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

public class Stacktrace {
    private static final int SAFETY_DEPTH = 4;
    private static final String TEST_POSTFIX = "Test";

    private Stacktrace() {
    }

    public static String getTestCallerClassMethodName() {
        return Stacktrace.getTestCallerClassMethodName(false);
    }

    public static String getTestCallerClassMethodNameLineNumber() {
        return Stacktrace.getTestCallerClassMethodName(true);
    }

    private static String getTestCallerClassMethodName(boolean includeLineNumber) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getClassName().endsWith(TEST_POSTFIX)) continue;
            return Stacktrace.buildClassMethodName(elements, i, includeLineNumber);
        }
        return Stacktrace.buildClassMethodName(elements, 4, includeLineNumber);
    }

    private static String buildClassMethodName(StackTraceElement[] elements, int depth, boolean includeLineNumber) {
        depth = Math.min(depth, elements.length - 1);
        StringBuilder builder = new StringBuilder();
        builder.append(elements[depth].getClassName()).append("#").append(elements[depth].getMethodName());
        if (includeLineNumber) {
            builder.append(":").append(elements[depth].getLineNumber());
        }
        return builder.toString();
    }
}

