/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyUtil {
    public static final String FIRST_API_LEVEL = "ro.product.first_api_level";
    private static final String BOARD_API_LEVEL = "ro.board.api_level";
    private static final String BOARD_FIRST_API_LEVEL = "ro.board.first_api_level";
    private static final String BUILD_TAGS_PROPERTY = "ro.build.tags";
    private static final String BUILD_TYPE_PROPERTY = "ro.build.type";
    private static final String MANUFACTURER_PROPERTY = "ro.product.manufacturer";
    private static final String TAG_DEV_KEYS = "dev-keys";
    private static final String VENDOR_API_LEVEL = "ro.vendor.api_level";
    private static final String VNDK_VERSION = "ro.vndk.version";
    public static final int INT_VALUE_IF_UNSET = -1;
    public static final int API_LEVEL_CURRENT = 10000;
    public static final String GOOGLE_SETTINGS_QUERY = "content query --uri content://com.google.settings/partner";

    private PropertyUtil() {
    }

    public static boolean isUserBuild(ITestDevice device) throws DeviceNotAvailableException {
        return PropertyUtil.propertyEquals(device, BUILD_TYPE_PROPERTY, "user");
    }

    public static boolean isDevKeysBuild(ITestDevice device) throws DeviceNotAvailableException {
        String buildTags = device.getProperty(BUILD_TAGS_PROPERTY);
        for (String tag : buildTags.split(",")) {
            if (!TAG_DEV_KEYS.equals(tag.trim())) continue;
            return true;
        }
        return false;
    }

    public static int getFirstApiLevel(ITestDevice device) throws DeviceNotAvailableException {
        int firstApiLevel = PropertyUtil.getPropertyInt(device, FIRST_API_LEVEL);
        return firstApiLevel == -1 ? device.getApiLevel() : firstApiLevel;
    }

    public static int getVsrApiLevel(ITestDevice device) throws DeviceNotAvailableException {
        String[] boardApiLevelProps;
        int vendorApiLevel = PropertyUtil.getPropertyInt(device, VENDOR_API_LEVEL);
        if (vendorApiLevel != -1) {
            return vendorApiLevel;
        }
        for (String apiLevelProp : boardApiLevelProps = new String[]{BOARD_API_LEVEL, BOARD_FIRST_API_LEVEL}) {
            int apiLevel = PropertyUtil.getPropertyInt(device, apiLevelProp);
            if (apiLevel == -1) continue;
            return Math.min(apiLevel, PropertyUtil.getFirstApiLevel(device));
        }
        return PropertyUtil.getFirstApiLevel(device);
    }

    public static int getVendorApiLevel(ITestDevice device) throws DeviceNotAvailableException {
        String[] vendorApiLevelProps;
        for (String prop : vendorApiLevelProps = new String[]{BOARD_API_LEVEL, BOARD_FIRST_API_LEVEL, VNDK_VERSION}) {
            int apiLevel = PropertyUtil.getPropertyInt(device, prop);
            if (apiLevel == -1) continue;
            return apiLevel;
        }
        return 10000;
    }

    public static boolean isVendorApiLevelNewerThan(ITestDevice device, int apiLevel) throws DeviceNotAvailableException {
        return PropertyUtil.getVendorApiLevel(device) > apiLevel;
    }

    public static boolean isVendorApiLevelAtLeast(ITestDevice device, int apiLevel) throws DeviceNotAvailableException {
        return PropertyUtil.getVendorApiLevel(device) >= apiLevel;
    }

    public static String getManufacturer(ITestDevice device) throws DeviceNotAvailableException {
        return device.getProperty(MANUFACTURER_PROPERTY);
    }

    public static Map<String, String> getClientIds(ITestDevice device) throws DeviceNotAvailableException {
        HashMap<String, String> clientIds = new HashMap<String, String>();
        String queryOutput = device.executeShellCommand(GOOGLE_SETTINGS_QUERY);
        for (String line : queryOutput.split("[\\r?\\n]+")) {
            Pattern pattern = Pattern.compile("name=([a-z_]*), value=(.*)$");
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (!name.contains("client_id")) continue;
            clientIds.put(name, value);
        }
        return clientIds;
    }

    public static boolean propertyExists(ITestDevice device, String property) throws DeviceNotAvailableException {
        return device.getProperty(property) != null;
    }

    public static boolean propertyEquals(ITestDevice device, String property, String value) throws DeviceNotAvailableException {
        if (value == null) {
            return !PropertyUtil.propertyExists(device, property);
        }
        return value.equals(device.getProperty(property));
    }

    public static boolean propertyMatches(ITestDevice device, String property, String regex) throws DeviceNotAvailableException {
        if (regex == null || regex.isEmpty()) {
            return !PropertyUtil.propertyExists(device, property);
        }
        String value = device.getProperty(property);
        return value == null ? false : value.matches(regex);
    }

    public static int getPropertyInt(ITestDevice device, String property) throws DeviceNotAvailableException {
        String value = device.getProperty(property);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

