/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.StreamUtil;
import com.google.common.base.Joiner;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public abstract class LogcatInspector {
    private static final int SMALL_LOGCAT_DELAY = 1000;

    protected abstract InputStream executeShellCommand(String var1) throws IOException;

    public String mark(String tag) throws IOException {
        String uniqueString = ":::" + UUID.randomUUID().toString();
        Closeables.closeQuietly((InputStream)this.executeShellCommand("log -t " + tag + " " + uniqueString));
        this.assertLogcatContainsInOrder(tag + ":* *:S", 5, uniqueString);
        return uniqueString;
    }

    public void assertLogcatContainsInOrder(String filterSpec, int maxTimeoutInSeconds, String ... logcatStrings) throws AssertionError, IOException {
        try {
            int nextStringIndex = this.numberOfLogcatStringsFound(filterSpec, maxTimeoutInSeconds, logcatStrings);
            if (nextStringIndex < logcatStrings.length) {
                TestCase.fail((String)("Couldn't find " + logcatStrings[nextStringIndex] + (nextStringIndex > 0 ? " after " + logcatStrings[nextStringIndex - 1] : "") + " within " + maxTimeoutInSeconds + " seconds "));
            }
        }
        catch (InterruptedException e) {
            TestCase.fail((String)("Thread interrupted unexpectedly: " + e.getMessage()));
        }
    }

    public void assertLogcatDoesNotContainInOrder(int timeInSeconds, String ... logcatStrings) throws IOException {
        try {
            int stringsFound = this.numberOfLogcatStringsFound("", timeInSeconds, logcatStrings);
            if (stringsFound == logcatStrings.length) {
                TestCase.fail((String)("Found " + Joiner.on((String)", ").join((Object[])logcatStrings) + " that weren't expected"));
            }
        }
        catch (InterruptedException e) {
            TestCase.fail((String)("Thread interrupted unexpectedly: " + e.getMessage()));
        }
    }

    private int numberOfLogcatStringsFound(String filterSpec, int timeInSeconds, String ... logcatStrings) throws InterruptedException, IOException {
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeInSeconds);
        int stringIndex = 0;
        long lastEpochMicroseconds = 0L;
        while (timeout >= System.currentTimeMillis()) {
            String line;
            InputStream logcatStream = this.executeShellCommand("logcat -v epoch -v usec -d " + filterSpec);
            BufferedReader logcat = new BufferedReader(new InputStreamReader(logcatStream));
            while ((line = logcat.readLine()) != null) {
                String[] splitLine;
                String epochMicrosecondsStr;
                long epochMicroseconds;
                if (!line.contains(logcatStrings[stringIndex]) || (epochMicroseconds = Long.parseLong(epochMicrosecondsStr = (splitLine = line.stripLeading().split(" "))[0].replace(".", ""))) < lastEpochMicroseconds || ++stringIndex < logcatStrings.length) continue;
                StreamUtil.drainAndClose(logcat);
                return stringIndex;
            }
            Closeables.closeQuietly((Reader)logcat);
            Thread.sleep(1000L);
        }
        return stringIndex;
    }
}

