/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ApiLevelUtil;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import java.util.HashSet;
import java.util.Set;

public class FeatureUtil {
    public static final String AUTOMOTIVE_FEATURE = "android.hardware.type.automotive";
    public static final String LEANBACK_FEATURE = "android.software.leanback";
    public static final String LOW_RAM_FEATURE = "android.hardware.ram.low";
    public static final String TELEPHONY_FEATURE = "android.hardware.telephony";
    public static final String TV_FEATURE = "android.hardware.type.television";
    public static final String WATCH_FEATURE = "android.hardware.type.watch";
    public static final String FEATURE_MICROPHONE = "android.hardware.microphone";
    public static final String XR_API_FEATURE = "android.software.xr.api.spatial";

    public static boolean hasSystemFeature(ITestDevice device, String feature) throws DeviceNotAvailableException {
        return device.hasFeature(feature);
    }

    public static boolean hasAnySystemFeature(ITestDevice device, String ... features) throws DeviceNotAvailableException {
        for (String feature : features) {
            if (!device.hasFeature(feature)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllSystemFeatures(ITestDevice device, String ... features) throws DeviceNotAvailableException {
        for (String feature : features) {
            if (device.hasFeature(feature)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getAllFeatures(ITestDevice device) throws DeviceNotAvailableException {
        HashSet<String> allFeatures = new HashSet<String>();
        String output = device.executeShellCommand("pm list features");
        for (String feature : output.split("[\\r?\\n]+")) {
            allFeatures.add(feature.substring("feature:".length()));
        }
        return allFeatures;
    }

    public static boolean isTV(ITestDevice device) throws DeviceNotAvailableException {
        return FeatureUtil.hasAnySystemFeature(device, TV_FEATURE, LEANBACK_FEATURE);
    }

    public static boolean isWatch(ITestDevice device) throws DeviceNotAvailableException {
        return FeatureUtil.hasSystemFeature(device, WATCH_FEATURE);
    }

    public static boolean isAutomotive(ITestDevice device) throws DeviceNotAvailableException {
        return FeatureUtil.hasSystemFeature(device, AUTOMOTIVE_FEATURE);
    }

    public static boolean isXrHeadset(ITestDevice device) throws DeviceNotAvailableException {
        return FeatureUtil.hasSystemFeature(device, XR_API_FEATURE);
    }

    public static boolean isLowRam(ITestDevice device) throws DeviceNotAvailableException {
        return ApiLevelUtil.isAtLeast(device, 26) && FeatureUtil.hasSystemFeature(device, LOW_RAM_FEATURE);
    }

    public static boolean hasTelephony(ITestDevice device) throws DeviceNotAvailableException {
        return FeatureUtil.hasSystemFeature(device, TELEPHONY_FEATURE);
    }

    public static boolean hasMicrophone(ITestDevice device) throws DeviceNotAvailableException {
        return FeatureUtil.hasSystemFeature(device, FEATURE_MICROPHONE);
    }
}

