/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.targetprep.DynamicConfigPusher;
import com.android.compatibility.common.tradefed.util.DynamicConfigFileReader;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.dependencies.ExternalDependency;
import com.android.tradefed.dependencies.IExternalDependency;
import com.android.tradefed.dependencies.connectivity.NetworkDependency;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.contentprovider.ContentProviderHandler;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.UserHelper;
import com.android.tradefed.testtype.AndroidJUnitTest;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.xmlpull.v1.XmlPullParserException;

@OptionClass(alias="media-preparer")
public class MediaPreparer
extends BaseTargetPreparer
implements IExternalDependency,
IConfigurationReceiver {
    @Option(name="local-media-path", description="Absolute path of the media files directory, containing'bbb_short' and 'bbb_full' directories")
    private String mLocalMediaPath = null;
    @Option(name="skip-media-download", description="Whether to skip the media files precondition")
    private boolean mSkipMediaDownload = false;
    @Option(name="simple-caching-semantics", description="Whether to use the original, simple MediaPreparer caching semantics")
    private boolean mSimpleCachingSemantics = false;
    @Option(name="media-download-only", description="Only download media files; do not run instrumentation or copy files")
    private boolean mMediaDownloadOnly = false;
    @Option(name="push-all", description="Push everything downloaded to the device, use 'media-folder-name' to specify the destination dir name.")
    private boolean mPushAll = false;
    @Option(name="dynamic-config-module", description="For a target preparer, the 'module' of the configuration is the test suite.")
    private String mDynamicConfigModule = "cts";
    @Option(name="media-folder-name", description="This serves two purposes. When option 'push-all' is set, this specifies the on-device directory where media files are pushed; if the path does not begin with /, it is a subdirectory inside the /sdcard/test directory. When 'local-media-path' is not specified, this names a subdirectory within the hosts's temp directory where the media files will be downloaded before being sent to the device.")
    private String mMediaFolderName = "android-cts-media";
    @Option(name="use-legacy-folder-structure", description="Use legacy folder structure to store big buck bunny clips. When this is set to false, name specified in media-folder-name will be used. Default: true")
    private boolean mUseLegacyFolderStructure = true;
    protected String mBaseDeviceModuleDir;
    protected String mBaseDeviceShortDir;
    protected String mBaseDeviceFullDir;
    protected Resolution mMaxRes = null;
    protected String mFailureStackTrace = null;
    private int mUserId = -1;
    private IConfiguration mModuleConfiguration;
    protected static final String MEDIA_FOLDER_NAME = "android-cts-media";
    private static final String MEDIA_FILES_URL_KEY = "media_files_url";
    private static final String APP_APK = "CtsMediaPreparerApp.apk";
    private static final String APP_PKG_NAME = "android.mediastress.cts.preconditions.app";
    private static final String RESOLUTION_STRING_KEY = "resolution";
    protected static final Resolution[] RESOLUTIONS = new Resolution[]{new Resolution(176, 144), new Resolution(480, 360), new Resolution(720, 480), new Resolution(1280, 720), new Resolution(1920, 1080)};
    private static final String SENTINEL = ".download-completed";
    private File localSentinel;
    protected static final String TOC_NAME = "contents.toc";

    @Override
    public Set<ExternalDependency> getDependencies() {
        HashSet<ExternalDependency> dependencies = new HashSet<ExternalDependency>();
        if (!this.mSkipMediaDownload) {
            dependencies.add(new NetworkDependency());
        }
        return dependencies;
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mModuleConfiguration = configuration;
    }

    public static File getDefaultMediaDir() {
        return new File(System.getProperty("java.io.tmpdir"), MEDIA_FOLDER_NAME);
    }

    protected File getMediaDir() {
        return new File(System.getProperty("java.io.tmpdir"), this.mMediaFolderName);
    }

    protected boolean mediaFilesExistOnDevice(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mPushAll) {
            String sentinelPath = this.mBaseDeviceModuleDir + SENTINEL;
            boolean exists = device.doesFileExist(sentinelPath, this.mUserId);
            LogUtil.CLog.i((String)("sentinel " + sentinelPath + (exists ? " exists" : " is missing")));
            return exists;
        }
        for (Resolution resolution : RESOLUTIONS) {
            if (resolution.width > this.mMaxRes.width) break;
            String deviceShortFilePath = this.mBaseDeviceShortDir + resolution.toString();
            String deviceFullFilePath = this.mBaseDeviceFullDir + resolution.toString();
            String deviceShortSentinelPath = deviceShortFilePath + File.separator + SENTINEL;
            String deviceFullSentinelPath = deviceFullFilePath + File.separator + SENTINEL;
            if (!device.doesFileExist(deviceShortSentinelPath, this.mUserId)) {
                LogUtil.CLog.i((String)("Missing Sentinel file " + deviceShortSentinelPath));
                return false;
            }
            if (!device.doesFileExist(deviceFullSentinelPath, this.mUserId)) {
                LogUtil.CLog.i((String)("Missing Sentinel file " + deviceFullSentinelPath));
                return false;
            }
            LogUtil.CLog.i((String)("Sentinels present for resolution: " + resolution.toString()));
        }
        LogUtil.CLog.i((String)"Sentinel files present");
        return true;
    }

    private void updateLocalMediaPath(ITestDevice device, File mediaFolder) throws TargetSetupError {
        String[] entries = mediaFolder.list();
        if (entries.length == 0) {
            throw new TargetSetupError(String.format("Unexpectedly empty directory %s", mediaFolder.getAbsolutePath()), device.getDeviceDescriptor());
        }
        if (entries.length > 2) {
            throw new TargetSetupError(String.format("Unexpected contents in directory %s", mediaFolder.getAbsolutePath()), device.getDeviceDescriptor());
        }
        int slot = 0;
        if (entries[slot].equals(TOC_NAME)) {
            if (entries.length == 1) {
                throw new TargetSetupError(String.format("Missing contents in directory %s", mediaFolder.getAbsolutePath()), device.getDeviceDescriptor());
            }
            slot = 1;
        }
        this.mLocalMediaPath = new File(mediaFolder, entries[slot]).getAbsolutePath();
    }

    private void generateDirectoryToc(FileWriter myWriter, File myFolder, String leadingPath) throws IOException {
        String prefixPath = leadingPath.equals("") ? "" : leadingPath + File.separator;
        for (String fileName : myFolder.list()) {
            myWriter.write(prefixPath + fileName + "\n");
            File oneFile = new File(myFolder, fileName);
            if (!oneFile.isDirectory()) continue;
            String newLeading = prefixPath + fileName;
            this.generateDirectoryToc(myWriter, oneFile, newLeading);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadMediaToHost(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError {
        Class<MediaPreparer> clazz = MediaPreparer.class;
        synchronized (MediaPreparer.class) {
            URL url;
            File mediaFolder = this.getMediaDir();
            LogUtil.CLog.i((String)("host downloads to: " + mediaFolder));
            if (mediaFolder.exists() && mediaFolder.list().length > 0) {
                if (this.mSimpleCachingSemantics) {
                    LogUtil.CLog.i((String)"old cache semantics: local directory exists, all is well");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return mediaFolder;
                }
                LogUtil.CLog.i((String)"new cache semantics: verify against a TOC");
                boolean passing = true;
                BufferedReader tocReader = null;
                try {
                    File tocFile = new File(mediaFolder, TOC_NAME);
                    if (!tocFile.exists()) {
                        passing = false;
                        LogUtil.CLog.i((String)("missing/inaccessible TOC: " + mediaFolder + File.separator + TOC_NAME));
                    } else {
                        tocReader = new BufferedReader(new FileReader(tocFile));
                        String line = tocReader.readLine();
                        while (line != null) {
                            File oneFile = new File(mediaFolder, line);
                            if (!oneFile.exists()) {
                                LogUtil.CLog.i((String)("missing TOC-listed file: " + mediaFolder + File.separator + line));
                                passing = false;
                                break;
                            }
                            line = tocReader.readLine();
                        }
                    }
                    StreamUtil.close((Closeable)tocReader);
                }
                catch (IOException | NullPointerException | SecurityException e) {
                    LogUtil.CLog.i((String)"TOC or contents missing, redownload");
                    passing = false;
                }
                finally {
                    StreamUtil.close(tocReader);
                }
                if (passing) {
                    LogUtil.CLog.i((String)("Host-cached copy is complete in " + mediaFolder));
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return mediaFolder;
                }
            }
            mediaFolder.mkdirs();
            try {
                String mediaUrlString = DynamicConfigFileReader.getValueFromConfig(buildInfo, this.mDynamicConfigModule, MEDIA_FILES_URL_KEY);
                url = new URL(mediaUrlString);
            }
            catch (IOException | XmlPullParserException e) {
                throw new TargetSetupError("Trouble finding media file download location with dynamic configuration", e, device.getDeviceDescriptor());
            }
            File mediaFolderZip = new File(mediaFolder.getAbsolutePath() + ".zip");
            FileWriter tocWriter = null;
            try {
                LogUtil.CLog.i((String)"Downloading media files from %s", (Object[])new Object[]{url.toString()});
                URLConnection conn = url.openConnection();
                InputStream in = conn.getInputStream();
                mediaFolderZip.createNewFile();
                FileUtil.writeToFile((InputStream)in, (File)mediaFolderZip);
                LogUtil.CLog.i((String)"Unzipping media files");
                ZipUtil.extractZip((ZipFile)new ZipFile(mediaFolderZip), (File)mediaFolder);
                if (!this.mSimpleCachingSemantics) {
                    LogUtil.CLog.i((String)"Generating cache TOC");
                    File tocFile = new File(mediaFolder, TOC_NAME);
                    tocWriter = new FileWriter(tocFile, false);
                    this.generateDirectoryToc(tocWriter, mediaFolder, "");
                }
            }
            catch (IOException e) {
                FileUtil.recursiveDelete((File)mediaFolder);
                throw new TargetSetupError(String.format("Failed to download and open media files on host machine at '%s'. These media files are required for compatibility tests.", mediaFolderZip), (Throwable)e, device.getDeviceDescriptor(), false);
            }
            finally {
                FileUtil.deleteFile((File)mediaFolderZip);
                StreamUtil.close(tocWriter);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mediaFolder;
        }
    }

    protected void copyMediaFiles(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mPushAll) {
            this.copyAll(device);
            return;
        }
        this.copyVideoFiles(device);
    }

    protected void copyVideoFiles(ITestDevice device) throws DeviceNotAvailableException {
        for (Resolution resolution : RESOLUTIONS) {
            if (resolution.width > this.mMaxRes.width) {
                LogUtil.CLog.i((String)"Media file copying complete");
                return;
            }
            String deviceShortFilePath = this.mBaseDeviceShortDir + resolution.toString();
            String deviceFullFilePath = this.mBaseDeviceFullDir + resolution.toString();
            String deviceShortSentinelPath = deviceShortFilePath + File.separator + SENTINEL;
            String deviceFullSentinelPath = deviceFullFilePath + File.separator + SENTINEL;
            if (!device.doesFileExist(deviceShortSentinelPath, this.mUserId)) {
                LogUtil.CLog.i((String)"Copying short files of resolution %s to device", (Object[])new Object[]{resolution.toString()});
                String localShortDirName = "bbb_short/" + resolution.toString();
                File localShortDir = new File(this.mLocalMediaPath, localShortDirName);
                device.pushDir(localShortDir, deviceShortFilePath, this.mUserId);
                device.pushFile(this.localSentinel, deviceShortSentinelPath, this.mUserId);
                LogUtil.CLog.i((String)("Placed sentinel on device at " + deviceShortSentinelPath));
            }
            if (device.doesFileExist(deviceFullSentinelPath, this.mUserId)) continue;
            LogUtil.CLog.i((String)"Copying full files of resolution %s to device", (Object[])new Object[]{resolution.toString()});
            String localFullDirName = "bbb_full/" + resolution.toString();
            File localFullDir = new File(this.mLocalMediaPath, localFullDirName);
            device.pushDir(localFullDir, deviceFullFilePath, this.mUserId);
            device.pushFile(this.localSentinel, deviceFullSentinelPath, this.mUserId);
            LogUtil.CLog.i((String)("Placed sentinel on device at " + deviceFullSentinelPath));
        }
    }

    protected void copyAll(ITestDevice device) throws DeviceNotAvailableException {
        String deviceSentinelPath = this.mBaseDeviceModuleDir + SENTINEL;
        if (device.doesFileExist(deviceSentinelPath, this.mUserId)) {
            LogUtil.CLog.i((String)("device has " + deviceSentinelPath + " indicating all files are downloaded"));
            return;
        }
        LogUtil.CLog.i((String)("Copying files to device directory " + this.mBaseDeviceModuleDir));
        device.pushDir(new File(this.mLocalMediaPath), this.mBaseDeviceModuleDir, this.mUserId);
        device.pushFile(this.localSentinel, deviceSentinelPath, this.mUserId);
        LogUtil.CLog.i((String)("Placed sentinel on device at " + deviceSentinelPath));
    }

    protected void setMountPoint(ITestDevice device) {
        if (this.mMediaFolderName.startsWith("/")) {
            this.mBaseDeviceModuleDir = String.format("%s/", this.mMediaFolderName);
            this.mBaseDeviceShortDir = String.format("%s/bbb_short/", this.mMediaFolderName);
            this.mBaseDeviceFullDir = String.format("%s/bbb_full/", this.mMediaFolderName);
            return;
        }
        String mountPoint = device.getMountPoint("EXTERNAL_STORAGE");
        this.mBaseDeviceModuleDir = String.format("%s/test/%s/", mountPoint, this.mMediaFolderName);
        if (this.mUseLegacyFolderStructure) {
            this.mBaseDeviceShortDir = String.format("%s/test/bbb_short/", mountPoint);
            this.mBaseDeviceFullDir = String.format("%s/test/bbb_full/", mountPoint);
        } else {
            this.mBaseDeviceShortDir = String.format("%s/test/%s/bbb_short/", mountPoint, this.mMediaFolderName);
            this.mBaseDeviceFullDir = String.format("%s/test/%s/bbb_full/", mountPoint, this.mMediaFolderName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        this.mUserId = UserHelper.getRunTestsAsUser((TestInformation)testInfo);
        if (this.mSkipMediaDownload) {
            LogUtil.CLog.i((String)"Skipping media preparation");
            return;
        }
        if (!this.mMediaDownloadOnly) {
            this.setMountPoint(device);
            if (!this.mPushAll) {
                this.setMaxRes(testInfo);
            }
            if (this.mediaFilesExistOnDevice(device)) {
                LogUtil.CLog.i((String)"Media files found on the device");
                return;
            }
        }
        try {
            if (this.mLocalMediaPath == null) {
                File mediaFolder = this.downloadMediaToHost(device, buildInfo);
                this.updateLocalMediaPath(device, mediaFolder);
            }
            LogUtil.CLog.i((String)("Media files located on host at: " + this.mLocalMediaPath));
            FileWriter myWriter = null;
            try {
                this.localSentinel = File.createTempFile("download-sentinel", null);
                myWriter = new FileWriter(this.localSentinel, false);
                myWriter.write("Asset Download Completion Sentinel\n");
                String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss a, z";
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a, z");
                myWriter.write("Downloaded at: " + sdf.format(cal.getTime()) + "\n");
                myWriter.write("Cached on host   path: " + this.mLocalMediaPath + "\n");
                myWriter.write("Pushed to device path: " + this.mBaseDeviceModuleDir + "\n");
                StreamUtil.close((Closeable)myWriter);
            }
            catch (IOException e) {
                LogUtil.CLog.w((String)"error creating the local sentinel file, device installation may fail");
            }
            finally {
                StreamUtil.close(myWriter);
            }
            if (!this.mMediaDownloadOnly) {
                this.copyMediaFiles(device);
            }
        }
        finally {
            FileUtil.deleteFile((File)this.localSentinel);
            this.localSentinel = null;
        }
    }

    protected void setUserId(int testUser) {
        this.mUserId = testUser;
    }

    protected void setMaxRes(TestInformation testInfo) throws DeviceNotAvailableException, TargetSetupError {
        MediaPreparerListener listener = new MediaPreparerListener();
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        File apkFile = null;
        try {
            apkFile = buildHelper.getTestFile(APP_APK);
            if (!apkFile.exists()) {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException e) {
            throw new TargetSetupError(String.format("Could not find '%s'", APP_APK), (ErrorIdentifier)InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        if (device.getAppPackageInfo(APP_PKG_NAME) != null) {
            device.uninstallPackage(APP_PKG_NAME);
        }
        LogUtil.CLog.i((String)"Instrumenting package %s:", (Object[])new Object[]{APP_PKG_NAME});
        new ContentProviderHandler(device, Integer.valueOf(this.mUserId)).setUp();
        AndroidJUnitTest instrTest = new AndroidJUnitTest();
        instrTest.setDevice(device);
        instrTest.setInstallFile(apkFile);
        instrTest.setPackageName(APP_PKG_NAME);
        String moduleName = this.getDynamicModuleName();
        if (moduleName != null) {
            instrTest.addInstrumentationArg("module-name", moduleName);
        }
        instrTest.setConfiguration((IConfiguration)new Configuration("stub", "stub"));
        instrTest.run(testInfo, (ITestInvocationListener)listener);
        if (this.mFailureStackTrace != null) {
            throw new TargetSetupError(String.format("Retrieving maximum resolution failed with trace:\n%s", this.mFailureStackTrace), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        if (this.mMaxRes == null) {
            throw new TargetSetupError(String.format("Failed to pull resolution capabilities from device", new Object[0]), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    protected String getDynamicModuleName() throws TargetSetupError {
        String moduleName = null;
        boolean sameDevice = false;
        for (IDeviceConfiguration deviceConfig : this.mModuleConfiguration.getDeviceConfig()) {
            for (ITargetPreparer prep : deviceConfig.getTargetPreparers()) {
                if (prep instanceof DynamicConfigPusher) {
                    moduleName = ((DynamicConfigPusher)prep).createModuleName();
                    if (sameDevice) {
                        throw new TargetSetupError("DynamicConfigPusher needs to be configured before MediaPreparer in your module configuration.", (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
                    }
                }
                if (!prep.equals((Object)this)) continue;
                sameDevice = true;
                if (moduleName == null) continue;
                return moduleName;
            }
            moduleName = null;
            sameDevice = false;
        }
        return null;
    }

    protected static final class Resolution {
        private static final String PATTERN = "(\\d+)x(\\d+)";
        private static final int WIDTH_INDEX = 1;
        private static final int HEIGHT_INDEX = 2;
        private final int width;
        private final int height;

        private Resolution(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private Resolution(String resolution) {
            Pattern pattern = Pattern.compile(PATTERN);
            Matcher matcher = pattern.matcher(resolution);
            matcher.find();
            this.width = Integer.parseInt(matcher.group(1));
            this.height = Integer.parseInt(matcher.group(2));
        }

        public String toString() {
            return String.format("%dx%d", this.width, this.height);
        }

        public int getWidth() {
            return this.width;
        }
    }

    private class MediaPreparerListener
    implements ITestInvocationListener {
        private MediaPreparerListener() {
        }

        public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> metrics) {
            MetricMeasurement.Metric resMetric = metrics.get(MediaPreparer.RESOLUTION_STRING_KEY);
            if (resMetric != null) {
                MediaPreparer.this.mMaxRes = new Resolution(resMetric.getMeasurements().getSingleString());
            }
        }

        public void testFailed(TestDescription test, String trace) {
            MediaPreparer.this.mFailureStackTrace = trace;
        }
    }
}

