/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

@OptionClass(alias="result-reporter")
public class InteractiveResultReporter
implements ITestInvocationListener {
    static final String SCREENSHOTS_DIR_NAME = "screenshots";
    static final String SCREENSHOTS_METADATA_FILE_NAME = "screenshots_metadata.xml";
    static final String ENCODING = "UTF-8";
    static final String NS = null;
    static final String NAME_ATTR = "name";
    static final String ABI_ATTR = "abi";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String RESULT_TAG = "Result";
    static final String MODULE_TAG = "Module";
    static final String CASE_TAG = "TestCase";
    static final String TEST_TAG = "Test";
    private static final String SCREENSHOTS_TAG = "Screenshots";
    static final String SCREENSHOT_TAG = "Screenshot";
    static final String DEFAULT_MODULE_NAME = "UNKNOWN_MODULE";
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir;

    public void invocationStarted(IInvocationContext context) {
        if (this.mBuildHelper == null) {
            this.mBuildHelper = new CompatibilityBuildHelper((IBuildInfo)context.getBuildInfos().get(0));
            if (this.mResultDir == null) {
                try {
                    this.mResultDir = this.mBuildHelper.getResultDir();
                    LogUtil.CLog.i((String)"Initialized mResultDir: %s", (Object[])new Object[]{this.mResultDir});
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("An initialized result directory is required for the reporter!", e);
                }
            }
        }
    }

    public void invocationEnded(long elapsedTime) {
        if (!Files.exists(Paths.get(this.mResultDir.getAbsolutePath(), SCREENSHOTS_DIR_NAME), new LinkOption[0])) {
            LogUtil.CLog.i((String)"No screenshot files are generated for the invocation.");
            return;
        }
        try {
            this.genScreenshotsMetadataFile(this.getScreenshotsMetadataFilePath());
        }
        catch (IOException | XmlPullParserException e) {
            throw new RuntimeException("Failed to generate the screenshots_metadata.xml", e);
        }
    }

    File getScreenshotsMetadataFilePath() {
        return Paths.get(this.mResultDir.getAbsolutePath(), SCREENSHOTS_DIR_NAME, SCREENSHOTS_METADATA_FILE_NAME).toFile();
    }

    void genScreenshotsMetadataFile(File screenshotsMetadataFile) throws IOException, XmlPullParserException {
        XmlSerializer serializer = XmlPullParserFactory.newInstance((String)"org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer", null).newSerializer();
        serializer.setOutput((OutputStream)new FileOutputStream(screenshotsMetadataFile), ENCODING);
        serializer.startDocument(ENCODING, Boolean.valueOf(false));
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.processingInstruction("xml-stylesheet type=\"text/xsl\" href=\"compatibility_result.xsl\"");
        serializer.startTag(NS, RESULT_TAG);
        ArrayList moduleNameWithAbis = new ArrayList();
        ArrayList<String> screenshotsInRoot = new ArrayList<String>();
        try (Stream<Path> fileOrDirs = Files.list(Paths.get(this.mResultDir.getAbsolutePath(), SCREENSHOTS_DIR_NAME));){
            fileOrDirs.forEach(fileOrDir -> {
                if (Files.isDirectory(fileOrDir, new LinkOption[0])) {
                    moduleNameWithAbis.add(fileOrDir.getFileName().toString());
                } else if (InteractiveResultReporter.isScreenshotFile(fileOrDir)) {
                    screenshotsInRoot.add(fileOrDir.getFileName().toString());
                }
            });
        }
        Collections.sort(moduleNameWithAbis);
        for (String moduleNameWithAbi : moduleNameWithAbis) {
            serializer.startTag(NS, MODULE_TAG);
            InteractiveResultReporter.addModuleTagAttributes(serializer, moduleNameWithAbi);
            ArrayList<String> screenshotsOfModule = new ArrayList<String>();
            try (Stream<Path> fileOrDirs = Files.list(Paths.get(this.mResultDir.getAbsolutePath(), SCREENSHOTS_DIR_NAME, moduleNameWithAbi));){
                fileOrDirs.forEach(fileOrDir -> {
                    if (!Files.isDirectory(fileOrDir, new LinkOption[0]) && InteractiveResultReporter.isScreenshotFile(fileOrDir)) {
                        screenshotsOfModule.add(fileOrDir.getFileName().toString());
                    }
                });
            }
            InteractiveResultReporter.addScreenshotTags(serializer, screenshotsOfModule);
            serializer.endTag(NS, MODULE_TAG);
        }
        if (!screenshotsInRoot.isEmpty()) {
            serializer.startTag(NS, MODULE_TAG);
            serializer.attribute(NS, NAME_ATTR, DEFAULT_MODULE_NAME);
            InteractiveResultReporter.addScreenshotTags(serializer, screenshotsInRoot);
            serializer.endTag(NS, MODULE_TAG);
        }
        serializer.endTag(NS, RESULT_TAG);
        serializer.endDocument();
        LogUtil.CLog.i((String)"Successfully generated the screenshots metadata file: %s", (Object[])new Object[]{screenshotsMetadataFile});
    }

    private static void addModuleTagAttributes(XmlSerializer serializer, String moduleNameWithAbi) throws IOException {
        String[] splitModuleAbis = moduleNameWithAbi.split("__");
        if (splitModuleAbis.length == 2) {
            serializer.attribute(NS, NAME_ATTR, splitModuleAbis[0]);
            serializer.attribute(NS, ABI_ATTR, splitModuleAbis[1]);
        } else {
            serializer.attribute(NS, NAME_ATTR, moduleNameWithAbi);
        }
    }

    static boolean isScreenshotFile(Path filePath) {
        String extSuffix = filePath.getFileName().toString().toLowerCase(Locale.ROOT);
        return extSuffix.endsWith(".png") || extSuffix.endsWith(".jpeg") || extSuffix.endsWith(".jpg");
    }

    static void addScreenshotTags(XmlSerializer serializer, List<String> screenshotFileNames) throws IOException, XmlPullParserException {
        Map<String, Map<String, List<ScreenshotTagData>>> screenshotTagDatas = InteractiveResultReporter.getScreenshotTagDatas(screenshotFileNames);
        for (String testCaseName : screenshotTagDatas.keySet()) {
            serializer.startTag(NS, CASE_TAG);
            serializer.attribute(NS, NAME_ATTR, testCaseName);
            Map<String, List<ScreenshotTagData>> testCaseScreenshotTagDatas = screenshotTagDatas.get(testCaseName);
            for (String testName : testCaseScreenshotTagDatas.keySet()) {
                serializer.startTag(NS, TEST_TAG);
                serializer.attribute(NS, NAME_ATTR, testName);
                serializer.startTag(NS, SCREENSHOTS_TAG);
                List<ScreenshotTagData> testScreenshotTagDatas = testCaseScreenshotTagDatas.get(testName);
                for (ScreenshotTagData tagData : testScreenshotTagDatas) {
                    serializer.startTag(NS, SCREENSHOT_TAG);
                    serializer.attribute(NS, NAME_ATTR, tagData.mScreenshotName);
                    serializer.attribute(NS, DESCRIPTION_ATTR, tagData.mScreenshotDescription);
                    serializer.endTag(NS, SCREENSHOT_TAG);
                }
                serializer.endTag(NS, SCREENSHOTS_TAG);
                serializer.endTag(NS, TEST_TAG);
            }
            serializer.endTag(NS, CASE_TAG);
        }
    }

    static Map<String, Map<String, List<ScreenshotTagData>>> getScreenshotTagDatas(List<String> screenshotFileNames) {
        TreeMap<String, Map<String, List<ScreenshotTagData>>> screenshotTagDatas = new TreeMap<String, Map<String, List<ScreenshotTagData>>>();
        for (String screenshotFileName : screenshotFileNames) {
            ScreenshotTagData screenshotTagData = InteractiveResultReporter.getScreenshotTagData(screenshotFileName);
            screenshotTagDatas.putIfAbsent(screenshotTagData.mTestCaseName, new TreeMap());
            Map testCaseScreenshotTagDatas = (Map)screenshotTagDatas.get(screenshotTagData.mTestCaseName);
            testCaseScreenshotTagDatas.putIfAbsent(screenshotTagData.mTestName, new ArrayList());
            ((List)testCaseScreenshotTagDatas.get(screenshotTagData.mTestName)).add(screenshotTagData);
        }
        return screenshotTagDatas;
    }

    static ScreenshotTagData getScreenshotTagData(String screenshotFileName) {
        String[] screenshotDetails = screenshotFileName.split("__");
        if (screenshotDetails.length == 3) {
            String[] testDetails = screenshotDetails[0].split("#");
            if (testDetails.length == 2) {
                return new ScreenshotTagData(testDetails[0], testDetails[1], screenshotFileName, screenshotDetails[1]);
            }
            LogUtil.CLog.w((String)"Found a screenshot that doesn't contain test package and class info: %s", (Object[])new Object[]{screenshotFileName});
            return new ScreenshotTagData(screenshotDetails[0], screenshotDetails[0], screenshotFileName, screenshotDetails[1]);
        }
        LogUtil.CLog.i((String)"Found a screenshot that isn't taken via Interactive library: %s", (Object[])new Object[]{screenshotFileName});
        return new ScreenshotTagData(screenshotFileName, screenshotFileName, screenshotFileName, screenshotFileName);
    }

    static final class ScreenshotTagData {
        final String mTestCaseName;
        final String mTestName;
        final String mScreenshotName;
        final String mScreenshotDescription;

        ScreenshotTagData(String testCaseName, String testName, String screenshotName, String screenshotDescription) {
            this.mTestCaseName = testCaseName;
            this.mTestName = testName;
            this.mScreenshotName = screenshotName;
            this.mScreenshotDescription = screenshotDescription;
        }
    }
}

