/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.IShardableListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.skipped.SkipReason;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.util.HashMap;
import java.util.Map;

public class ConsoleReporter
implements IShardableListener {
    private static final String UNKNOWN_DEVICE = "unknown_device";
    @Option(name="quiet-output", description="Mute display of test results.")
    private boolean mQuietOutput = true;
    private String mDeviceSerial = "unknown_device";
    private boolean mTestFailed;
    private boolean mTestSkipped;
    private String mModuleId;
    private int mCurrentTestNum;
    private int mTotalTestsInModule;
    private int mPassedTests;
    private int mFailedTests;
    private int mNotExecutedTests;

    public void invocationStarted(IInvocationContext context) {
        if (context == null) {
            LogUtil.CLog.w((String)"InvocationContext should not be null");
            return;
        }
        ITestDevice primaryDevice = (ITestDevice)context.getDevices().get(0);
        this.mDeviceSerial = primaryDevice.getSerialNumber().replace("%", "%%");
    }

    public void testRunStarted(String id, int numTests) {
        boolean isRepeatModule = this.mModuleId != null && this.mModuleId.equals(id);
        this.mModuleId = id;
        this.mTotalTestsInModule = numTests;
        this.mCurrentTestNum = 0;
        this.mPassedTests = 0;
        this.mFailedTests = 0;
        this.mNotExecutedTests = 0;
        this.mTestFailed = false;
        this.logMessage("%s %s with %d test%s", isRepeatModule ? "Continuing" : "Starting", id, this.mTotalTestsInModule, this.mTotalTestsInModule > 1 ? "s" : "");
    }

    public void testStarted(TestDescription test) {
        this.mTestFailed = false;
        this.mTestSkipped = false;
        ++this.mCurrentTestNum;
    }

    public void testFailed(TestDescription test, String trace) {
        this.logProgress("%s fail: %s", test, trace);
        this.mTestFailed = true;
        ++this.mFailedTests;
    }

    public void testIgnored(TestDescription test) {
        this.logProgress("%s ignore", test);
        this.mTestSkipped = true;
    }

    public void testAssumptionFailure(TestDescription test, String trace) {
        this.logProgress("%s assumption failure", test);
        this.mTestSkipped = true;
    }

    public void testSkipped(TestDescription test, SkipReason reason) {
        this.logProgress("%s skip", test);
        this.mTestSkipped = true;
    }

    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        if (!this.mTestFailed && !this.mTestSkipped) {
            this.logProgress("%s pass", test);
            ++this.mPassedTests;
        }
    }

    public void testRunFailed(String errorMessage) {
        errorMessage = errorMessage.replaceAll("%", "%%");
        this.logMessage(errorMessage, new Object[0]);
    }

    public void testRunEnded(long elapsedTime, Map<String, String> metrics) {
        this.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(metrics));
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> metrics) {
        this.mNotExecutedTests = Math.max(this.mTotalTestsInModule - this.mCurrentTestNum, 0);
        String status = this.mNotExecutedTests > 0 ? "failed" : "completed";
        this.logMessage("%s %s in %s. %d passed, %d failed, %d not executed", this.mModuleId, status, TimeUtil.formatElapsedTime((long)elapsedTime), this.mPassedTests, this.mFailedTests, this.mNotExecutedTests);
    }

    public void testRunStopped(long elapsedTime) {
        this.logMessage("%s stopped (%s)", this.mModuleId, TimeUtil.formatElapsedTime((long)elapsedTime));
    }

    private void logProgress(String format, Object ... args) {
        format = String.format("[%s %s %s] %s", this.progress(), this.mModuleId, this.mDeviceSerial, format);
        this.log(format, args);
    }

    private void logMessage(String format, Object ... args) {
        format = String.format("[%s] %s", this.mDeviceSerial, format);
        this.log(format, args);
    }

    private void log(String format, Object ... args) {
        if (this.mQuietOutput) {
            LogUtil.CLog.i((String)format, (Object[])args);
        } else {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)format, (Object[])args);
        }
    }

    public IShardableListener clone() {
        ConsoleReporter clone = new ConsoleReporter();
        OptionCopier.copyOptionsNoThrow((Object)this, (Object)clone);
        return clone;
    }

    private String progress() {
        return String.format("%d/%d", this.mCurrentTestNum, this.mTotalTestsInModule);
    }

    boolean getTestFailed() {
        return this.mTestFailed;
    }

    boolean getTestSkipped() {
        return this.mTestSkipped;
    }

    String getModuleId() {
        return this.mModuleId;
    }

    int getCurrentTestNum() {
        return this.mCurrentTestNum;
    }

    int getTotalTestsInModule() {
        return this.mTotalTestsInModule;
    }

    int getPassedTests() {
        return this.mPassedTests;
    }

    int getFailedTests() {
        return this.mFailedTests;
    }
}

