/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.logging.flogger.backend;

import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.MetadataKey;
import com.google.common.flogger.backend.BaseMessageFormatter;
import com.google.common.flogger.backend.KeyValueFormatter;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.LogMessageFormatter;
import com.google.common.flogger.backend.MessageUtils;
import com.google.common.flogger.backend.MetadataHandler;
import com.google.common.flogger.backend.MetadataKeyValueHandlers;
import com.google.common.flogger.backend.MetadataProcessor;
import com.google.devtools.mobileharness.shared.util.logging.flogger.FloggerFormatterConstants;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

class MobileHarnessMessageFormatter
extends LogMessageFormatter {
    private static final MobileHarnessMessageFormatter INSTANCE = new MobileHarnessMessageFormatter();
    private static final boolean WITH_CONTEXT = FloggerFormatterConstants.withContext();
    private final MetadataHandler<MetadataKey.KeyValueHandler> handler = MetadataKeyValueHandlers.getDefaultHandler(ImmutableSet.of());

    public static MobileHarnessMessageFormatter getInstance() {
        return INSTANCE;
    }

    @Override
    @CanIgnoreReturnValue
    public StringBuilder append(LogData logData, MetadataProcessor metadata, StringBuilder buffer) {
        BaseMessageFormatter.appendFormattedMessage(logData, buffer);
        if (WITH_CONTEXT) {
            MobileHarnessMessageFormatter.appendContext(metadata, this.handler, buffer);
        }
        return buffer;
    }

    @Override
    public String format(LogData logData, MetadataProcessor metadata) {
        if (MobileHarnessMessageFormatter.mustBeFormatted(logData, metadata)) {
            return this.append(logData, metadata, new StringBuilder()).toString();
        }
        return MobileHarnessMessageFormatter.getLiteralLogMessage(logData);
    }

    private static void appendContext(MetadataProcessor metadataProcessor, MetadataHandler<MetadataKey.KeyValueHandler> metadataHandler, StringBuilder buffer) {
        KeyValueFormatter kvf = new KeyValueFormatter("[CONTEXT ", " ]", buffer);
        metadataProcessor.process(metadataHandler, kvf);
        kvf.done();
    }

    private static String getLiteralLogMessage(LogData logData) {
        return MessageUtils.safeToString(logData.getLiteralArgument());
    }

    private static boolean mustBeFormatted(LogData logData, MetadataProcessor metadata) {
        return logData.getTemplateContext() != null || metadata.keyCount() > 0;
    }

    private MobileHarnessMessageFormatter() {
    }
}

