/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.inject;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.devtools.mobileharness.shared.util.concurrent.ThreadPools;
import com.google.devtools.mobileharness.shared.util.time.Sleeper;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.time.Clock;
import java.time.InstantSource;
import java.util.concurrent.ExecutorService;
import javax.inject.Singleton;

public class CommonModule
extends AbstractModule {
    @Provides
    @Singleton
    Clock provideClock() {
        return Clock.systemUTC();
    }

    @Provides
    @Singleton
    ExecutorService provideExecutorService(ListeningExecutorService listeningExecutorService) {
        return listeningExecutorService;
    }

    @Provides
    @Singleton
    InstantSource provideInstantSource() {
        return InstantSource.system();
    }

    @Provides
    @Singleton
    ListeningExecutorService provideThreadPool() {
        return ThreadPools.createStandardThreadPool("main-thread-pool");
    }

    @Provides
    @Singleton
    ListeningScheduledExecutorService provideScheduledThreadPool() {
        return ThreadPools.createStandardScheduledThreadPool("main-scheduled-thread-pool", 10);
    }

    @Provides
    @Singleton
    Sleeper provideSleeper() {
        return Sleeper.defaultSleeper();
    }
}

