/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.concurrent;

import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;

public class ThreadFactoryUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    public static ThreadFactory createThreadFactory(String threadNamePrefix) {
        return ThreadFactoryUtil.createThreadFactory(threadNamePrefix, false);
    }

    public static ThreadFactory createThreadFactory(String threadNamePrefix, boolean daemon) {
        return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").setDaemon(daemon).setUncaughtExceptionHandler((thread, throwable) -> ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause(throwable)).log("Uncaught exception from thread [%s]", thread.getName())).build();
    }

    private ThreadFactoryUtil() {
    }
}

