/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.comparator;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.shared.util.comparator.AutoValue_NaturalSortOrderComparator_Section;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class NaturalSortOrderComparator
implements Comparator<String> {
    private final Map<String, ImmutableList<Section>> sectionsCache = new ConcurrentHashMap<String, ImmutableList<Section>>();

    @Override
    public int compare(String string1, String string2) {
        ImmutableList sections1 = this.sectionsCache.computeIfAbsent(string1, NaturalSortOrderComparator::preprocess);
        ImmutableList sections2 = this.sectionsCache.computeIfAbsent(string2, NaturalSortOrderComparator::preprocess);
        int sectionNum1 = sections1.size();
        int sectionNum2 = sections2.size();
        int secondaryComparingResult = 0;
        int minSectionNum = Math.min(sectionNum1, sectionNum2);
        for (int i = 0; i < minSectionNum; ++i) {
            int comparingResult;
            Section section1 = (Section)sections1.get(i);
            Section section2 = (Section)sections2.get(i);
            Optional<Integer> number1 = section1.number();
            Optional<Integer> number2 = section2.number();
            if (number1.isPresent() && number2.isEmpty()) {
                comparingResult = -1;
            } else if (number1.isEmpty() && number2.isPresent()) {
                comparingResult = 1;
            } else if (number1.isEmpty()) {
                comparingResult = section1.substring().compareTo(section2.substring());
            } else {
                comparingResult = Integer.compare(number1.get(), number2.get());
                if (comparingResult == 0 && secondaryComparingResult == 0) {
                    secondaryComparingResult = section2.substring().compareTo(section1.substring());
                }
            }
            if (comparingResult == 0) continue;
            return comparingResult;
        }
        int sectionNumComparingResult = Integer.compare(sectionNum1, sectionNum2);
        return sectionNumComparingResult == 0 ? secondaryComparingResult : sectionNumComparingResult;
    }

    private static ImmutableList<Section> preprocess(String string) {
        ImmutableList.Builder sections = ImmutableList.builder();
        boolean inSection = false;
        int sectionStart = 0;
        int sectionEnd = 0;
        boolean sectionIsNumber = false;
        int stringLength = string.length();
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            boolean isDigit = Character.isDigit(c);
            if (!inSection || isDigit != sectionIsNumber) {
                if (inSection) {
                    sections.add(NaturalSortOrderComparator.createSection(string, sectionStart, sectionEnd, sectionIsNumber));
                }
                inSection = true;
                sectionStart = i;
                sectionEnd = i + 1;
                sectionIsNumber = isDigit;
                continue;
            }
            ++sectionEnd;
        }
        if (inSection) {
            sections.add(NaturalSortOrderComparator.createSection(string, sectionStart, sectionEnd, sectionIsNumber));
        }
        return sections.build();
    }

    private static Section createSection(String string, int start, int end, boolean isNumber) {
        String substring = string.substring(start, end);
        return Section.of(substring, isNumber ? Integer.valueOf(Integer.parseInt(substring)) : null);
    }

    @AutoValue
    static abstract class Section {
        Section() {
        }

        private static Section of(String substring, @Nullable Integer number) {
            return new AutoValue_NaturalSortOrderComparator_Section(substring, Optional.ofNullable(number));
        }

        abstract String substring();

        abstract Optional<Integer> number();
    }
}

