/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command.java;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.devtools.mobileharness.shared.util.command.java.AutoValue_JavaCommandCreator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class JavaCommandCreator {
    public static JavaCommandCreator of(boolean useStandardInvocationForm, @Nullable String javaLauncherPath) {
        Preconditions.checkArgument(!useStandardInvocationForm || javaLauncherPath != null);
        return new AutoValue_JavaCommandCreator(useStandardInvocationForm, Optional.ofNullable(javaLauncherPath));
    }

    public abstract boolean useStandardInvocationForm();

    public abstract Optional<String> javaLauncherPath();

    public List<String> createJavaCommand(String jarFilePath, List<String> arguments, List<String> nativeArguments) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (this.useStandardInvocationForm()) {
            result.add(this.javaLauncherPath().orElseThrow(AssertionError::new));
            result.addAll(nativeArguments);
            result.add("-jar");
            result.add(jarFilePath);
        } else {
            result.add(jarFilePath);
            result.addAll(nativeArguments);
            result.add("run");
        }
        result.addAll(arguments);
        return result.build();
    }
}

