/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.command;

import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;

public class CommandResult {
    private static final int MAX_OUTPUT_LENGTH_IN_MSG = 2000;
    private final String stdout;
    private final String stderr;
    private final int exitCode;
    private final boolean isTimeout;
    private final boolean isStopped;
    private final Supplier<String> toStringSupplier;
    private final Supplier<String> toStringWithoutTruncationSupplier;
    private final Supplier<String> stdoutWithoutTrailingLineTerminatorSupplier;
    private final Supplier<String> stderrWithoutTrailingLineTerminatorSupplier;

    public static String removeTrailingLineTerminator(String output) {
        if (Strings.isNullOrEmpty(output)) {
            return output;
        }
        int len = output.length();
        if (output.endsWith("\r\n")) {
            return output.substring(0, len - 2);
        }
        if (output.endsWith("\r") || output.endsWith("\n")) {
            return output.substring(0, len - 1);
        }
        return output;
    }

    CommandResult(String stdout, String stderr, int exitCode, boolean isTimeout, boolean isStopped) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.exitCode = exitCode;
        this.isTimeout = isTimeout;
        this.isStopped = isStopped;
        this.toStringSupplier = Suppliers.memoize(() -> String.format("code=%d, out=[%s], err=[%s]", this.exitCode(), CommandResult.truncateOutput(this.stdout()), CommandResult.truncateOutput(this.stderr())));
        this.toStringWithoutTruncationSupplier = Suppliers.memoize(() -> String.format("code=%d, out=[%s], err=[%s]", this.exitCode(), this.stdout(), this.stderr()));
        this.stdoutWithoutTrailingLineTerminatorSupplier = Suppliers.memoize(() -> CommandResult.removeTrailingLineTerminator(this.stdout()));
        this.stderrWithoutTrailingLineTerminatorSupplier = Suppliers.memoize(() -> CommandResult.removeTrailingLineTerminator(this.stderr()));
    }

    public String stdout() {
        return this.stdout;
    }

    public String stderr() {
        return this.stderr;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public String toString() {
        return this.toStringSupplier.get();
    }

    public String toStringWithoutTruncation() {
        return this.toStringWithoutTruncationSupplier.get();
    }

    public String stdoutWithoutTrailingLineTerminator() {
        return this.stdoutWithoutTrailingLineTerminatorSupplier.get();
    }

    public String stderrWithoutTrailingLineTerminator() {
        return this.stderrWithoutTrailingLineTerminatorSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandResult)) {
            return false;
        }
        CommandResult that = (CommandResult)o;
        return this.exitCode == that.exitCode && this.stdout.equals(that.stdout) && this.stderr.equals(that.stderr);
    }

    public int hashCode() {
        return Objects.hash(this.stdout, this.stderr, this.exitCode);
    }

    private static String truncateOutput(String output) {
        if (output.length() < 2000) {
            return output;
        }
        int startLength = 1000;
        String start = output.substring(0, startLength);
        int endLength = 995;
        String end = output.substring(output.length() - endLength);
        return start + System.lineSeparator() + "..." + System.lineSeparator() + end;
    }
}

