/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.comm.stub;

import com.google.devtools.mobileharness.shared.util.comm.stub.ChannelFactory;
import com.google.devtools.mobileharness.shared.util.concurrent.ThreadPools;
import io.grpc.ManagedChannel;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class ManagedChannelSupplier
implements Function<String, ManagedChannel> {
    private final Executor executor;

    private ManagedChannelSupplier(Executor executor) {
        this.executor = executor;
    }

    public static ManagedChannelSupplier getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public ManagedChannel apply(String grpcTarget) {
        return ChannelFactory.createChannel(grpcTarget, this.executor);
    }

    private static class SingletonHolder {
        private static final ManagedChannelSupplier INSTANCE = new ManagedChannelSupplier(ThreadPools.createStandardThreadPool("managed-grpc-channel-executor"));

        private SingletonHolder() {
        }
    }
}

