/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.base;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class TableFormatter {
    private static final int COLUMN_SPACING = 2;

    public static String displayTable(List<? extends List<String>> table) {
        Preconditions.checkArgument(!table.isEmpty());
        StringBuilder result = new StringBuilder();
        List<Integer> columnSizes = TableFormatter.calculateColumnSizes(table);
        for (int rowIndex = 0; rowIndex < table.size(); ++rowIndex) {
            List<String> row = table.get(rowIndex);
            for (int columnIndex = 0; columnIndex < row.size(); ++columnIndex) {
                String column = row.get(columnIndex);
                result.append(column);
                if (columnIndex >= row.size() - 1) continue;
                result.append(" ".repeat(columnSizes.get(columnIndex) - column.length()));
            }
            if (rowIndex >= table.size() - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }

    private static List<Integer> calculateColumnSizes(List<? extends List<String>> table) {
        ArrayList<Integer> columnSizes = new ArrayList<Integer>();
        for (List<String> list : table) {
            for (int columnIndex = 0; columnIndex < list.size(); ++columnIndex) {
                if (columnIndex >= columnSizes.size()) {
                    columnSizes.add(columnIndex, 0);
                }
                int columnSize = list.get(columnIndex).length() + 2;
                if ((Integer)columnSizes.get(columnIndex) >= columnSize) continue;
                columnSizes.set(columnIndex, columnSize);
            }
        }
        return columnSizes;
    }

    private TableFormatter() {
    }
}

