/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.mobileharness.shared.util.base;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StackSet<E> {
    private final List<E> elements = new ArrayList();
    private final Map<E, Integer> indexes = new HashMap<E, Integer>();
    @Nullable
    private volatile E lastElement;

    public void add(E e) {
        Preconditions.checkNotNull(e);
        Preconditions.checkState(!this.indexes.containsKey(e));
        this.indexes.put(e, this.elements.size());
        this.elements.add(e);
        this.lastElement = e;
    }

    @Nullable
    public E getLast() {
        return this.lastElement;
    }

    public void removeUntilLast(E e) {
        if (!this.indexes.containsKey(e)) {
            return;
        }
        int index = this.indexes.get(e);
        for (int i = this.elements.size() - 1; i >= index; --i) {
            this.indexes.remove(this.elements.remove(i));
        }
        this.lastElement = index == 0 ? null : this.elements.get(index - 1);
    }
}

